package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait InstanceHealthCheckType {
  def unwrap: software.amazon.awssdk.services.ecs.model.InstanceHealthCheckType
}
object InstanceHealthCheckType {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.InstanceHealthCheckType
  ): zio.aws.ecs.model.InstanceHealthCheckType = value match {
    case software.amazon.awssdk.services.ecs.model.InstanceHealthCheckType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.InstanceHealthCheckType.CONTAINER_RUNTIME =>
      val r = CONTAINER_RUNTIME
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ecs.model.InstanceHealthCheckType {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.InstanceHealthCheckType =
      software.amazon.awssdk.services.ecs.model.InstanceHealthCheckType.UNKNOWN_TO_SDK_VERSION
  }
  case object CONTAINER_RUNTIME
      extends zio.aws.ecs.model.InstanceHealthCheckType {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.InstanceHealthCheckType =
      software.amazon.awssdk.services.ecs.model.InstanceHealthCheckType.CONTAINER_RUNTIME
  }
}
