package zio.aws.ecs.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.{Timestamp, Integer}
import scala.jdk.CollectionConverters._
final case class ContainerInstance(
    containerInstanceArn: Optional[String] = Optional.Absent,
    ec2InstanceId: Optional[String] = Optional.Absent,
    capacityProviderName: Optional[String] = Optional.Absent,
    version: Optional[Long] = Optional.Absent,
    versionInfo: Optional[zio.aws.ecs.model.VersionInfo] = Optional.Absent,
    remainingResources: Optional[Iterable[zio.aws.ecs.model.Resource]] =
      Optional.Absent,
    registeredResources: Optional[Iterable[zio.aws.ecs.model.Resource]] =
      Optional.Absent,
    status: Optional[String] = Optional.Absent,
    statusReason: Optional[String] = Optional.Absent,
    agentConnected: Optional[Boolean] = Optional.Absent,
    runningTasksCount: Optional[Integer] = Optional.Absent,
    pendingTasksCount: Optional[Integer] = Optional.Absent,
    agentUpdateStatus: Optional[zio.aws.ecs.model.AgentUpdateStatus] =
      Optional.Absent,
    attributes: Optional[Iterable[zio.aws.ecs.model.Attribute]] =
      Optional.Absent,
    registeredAt: Optional[Timestamp] = Optional.Absent,
    attachments: Optional[Iterable[zio.aws.ecs.model.Attachment]] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.ecs.model.Tag]] = Optional.Absent,
    healthStatus: Optional[zio.aws.ecs.model.ContainerInstanceHealthStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ContainerInstance = {
    import ContainerInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ContainerInstance
      .builder()
      .optionallyWith(
        containerInstanceArn.map(value => value: java.lang.String)
      )(_.containerInstanceArn)
      .optionallyWith(ec2InstanceId.map(value => value: java.lang.String))(
        _.ec2InstanceId
      )
      .optionallyWith(
        capacityProviderName.map(value => value: java.lang.String)
      )(_.capacityProviderName)
      .optionallyWith(version.map(value => value: java.lang.Long))(_.version)
      .optionallyWith(versionInfo.map(value => value.buildAwsValue()))(
        _.versionInfo
      )
      .optionallyWith(
        remainingResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.remainingResources)
      .optionallyWith(
        registeredResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.registeredResources)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .optionallyWith(agentConnected.map(value => value: java.lang.Boolean))(
        _.agentConnected
      )
      .optionallyWith(runningTasksCount.map(value => value: java.lang.Integer))(
        _.runningTasksCount
      )
      .optionallyWith(pendingTasksCount.map(value => value: java.lang.Integer))(
        _.pendingTasksCount
      )
      .optionallyWith(agentUpdateStatus.map(value => value.unwrap))(
        _.agentUpdateStatus
      )
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .optionallyWith(
        registeredAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.registeredAt)
      .optionallyWith(
        attachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachments)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(healthStatus.map(value => value.buildAwsValue()))(
        _.healthStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ContainerInstance.ReadOnly =
    zio.aws.ecs.model.ContainerInstance.wrap(buildAwsValue())
}
object ContainerInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ContainerInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ContainerInstance =
      zio.aws.ecs.model.ContainerInstance(
        containerInstanceArn.map(value => value),
        ec2InstanceId.map(value => value),
        capacityProviderName.map(value => value),
        version.map(value => value),
        versionInfo.map(value => value.asEditable),
        remainingResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        registeredResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value),
        statusReason.map(value => value),
        agentConnected.map(value => value),
        runningTasksCount.map(value => value),
        pendingTasksCount.map(value => value),
        agentUpdateStatus.map(value => value),
        attributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        registeredAt.map(value => value),
        attachments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        healthStatus.map(value => value.asEditable)
      )
    def containerInstanceArn: Optional[String]
    def ec2InstanceId: Optional[String]
    def capacityProviderName: Optional[String]
    def version: Optional[Long]
    def versionInfo: Optional[zio.aws.ecs.model.VersionInfo.ReadOnly]
    def remainingResources: Optional[List[zio.aws.ecs.model.Resource.ReadOnly]]
    def registeredResources: Optional[List[zio.aws.ecs.model.Resource.ReadOnly]]
    def status: Optional[String]
    def statusReason: Optional[String]
    def agentConnected: Optional[Boolean]
    def runningTasksCount: Optional[Integer]
    def pendingTasksCount: Optional[Integer]
    def agentUpdateStatus: Optional[zio.aws.ecs.model.AgentUpdateStatus]
    def attributes: Optional[List[zio.aws.ecs.model.Attribute.ReadOnly]]
    def registeredAt: Optional[Timestamp]
    def attachments: Optional[List[zio.aws.ecs.model.Attachment.ReadOnly]]
    def tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]]
    def healthStatus
        : Optional[zio.aws.ecs.model.ContainerInstanceHealthStatus.ReadOnly]
    def getContainerInstanceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerInstanceArn", containerInstanceArn)
    def getEc2InstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ec2InstanceId", ec2InstanceId)
    def getCapacityProviderName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("capacityProviderName", capacityProviderName)
    def getVersion: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("version", version)
    def getVersionInfo
        : ZIO[Any, AwsError, zio.aws.ecs.model.VersionInfo.ReadOnly] =
      AwsError.unwrapOptionField("versionInfo", versionInfo)
    def getRemainingResources
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Resource.ReadOnly]] =
      AwsError.unwrapOptionField("remainingResources", remainingResources)
    def getRegisteredResources
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Resource.ReadOnly]] =
      AwsError.unwrapOptionField("registeredResources", registeredResources)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getAgentConnected: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("agentConnected", agentConnected)
    def getRunningTasksCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("runningTasksCount", runningTasksCount)
    def getPendingTasksCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("pendingTasksCount", pendingTasksCount)
    def getAgentUpdateStatus
        : ZIO[Any, AwsError, zio.aws.ecs.model.AgentUpdateStatus] =
      AwsError.unwrapOptionField("agentUpdateStatus", agentUpdateStatus)
    def getAttributes
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Attribute.ReadOnly]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getRegisteredAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("registeredAt", registeredAt)
    def getAttachments
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Attachment.ReadOnly]] =
      AwsError.unwrapOptionField("attachments", attachments)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getHealthStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ecs.model.ContainerInstanceHealthStatus.ReadOnly
    ] = AwsError.unwrapOptionField("healthStatus", healthStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ContainerInstance
  ) extends zio.aws.ecs.model.ContainerInstance.ReadOnly {
    override val containerInstanceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.containerInstanceArn())
      .map(value => value: String)
    override val ec2InstanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ec2InstanceId())
      .map(value => value: String)
    override val capacityProviderName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityProviderName())
      .map(value => value: String)
    override val version: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: Long)
    override val versionInfo: Optional[zio.aws.ecs.model.VersionInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionInfo())
        .map(value => zio.aws.ecs.model.VersionInfo.wrap(value))
    override val remainingResources
        : Optional[List[zio.aws.ecs.model.Resource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remainingResources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Resource.wrap(item)
          }.toList
        )
    override val registeredResources
        : Optional[List[zio.aws.ecs.model.Resource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.registeredResources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Resource.wrap(item)
          }.toList
        )
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val statusReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => value: String)
    override val agentConnected: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.agentConnected())
      .map(value => value: Boolean)
    override val runningTasksCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.runningTasksCount())
      .map(value => value: Integer)
    override val pendingTasksCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingTasksCount())
      .map(value => value: Integer)
    override val agentUpdateStatus
        : Optional[zio.aws.ecs.model.AgentUpdateStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.agentUpdateStatus())
      .map(value => zio.aws.ecs.model.AgentUpdateStatus.wrap(value))
    override val attributes
        : Optional[List[zio.aws.ecs.model.Attribute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Attribute.wrap(item)
          }.toList
        )
    override val registeredAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.registeredAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val attachments
        : Optional[List[zio.aws.ecs.model.Attachment.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Attachment.wrap(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Tag.wrap(item)
          }.toList
        )
    override val healthStatus
        : Optional[zio.aws.ecs.model.ContainerInstanceHealthStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthStatus())
        .map(value =>
          zio.aws.ecs.model.ContainerInstanceHealthStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ContainerInstance
  ): zio.aws.ecs.model.ContainerInstance.ReadOnly = new Wrapper(impl)
}
