package zio.aws.ecs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.PortNumber
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ServiceConnectClientAlias(
    port: PortNumber,
    dnsName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ServiceConnectClientAlias = {
    import ServiceConnectClientAlias.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ServiceConnectClientAlias
      .builder()
      .port(PortNumber.unwrap(port): Integer)
      .optionallyWith(dnsName.map(value => value: java.lang.String))(_.dnsName)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ServiceConnectClientAlias.ReadOnly =
    zio.aws.ecs.model.ServiceConnectClientAlias.wrap(buildAwsValue())
}
object ServiceConnectClientAlias {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ServiceConnectClientAlias
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ServiceConnectClientAlias =
      zio.aws.ecs.model
        .ServiceConnectClientAlias(port, dnsName.map(value => value))
    def port: PortNumber
    def dnsName: Optional[String]
    def getPort: ZIO[Any, Nothing, PortNumber] = ZIO.succeed(port)
    def getDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dnsName", dnsName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ServiceConnectClientAlias
  ) extends zio.aws.ecs.model.ServiceConnectClientAlias.ReadOnly {
    override val port: PortNumber =
      zio.aws.ecs.model.primitives.PortNumber(impl.port())
    override val dnsName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ServiceConnectClientAlias
  ): zio.aws.ecs.model.ServiceConnectClientAlias.ReadOnly = new Wrapper(impl)
}
