package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetTaskProtectionRequest(
    cluster: String,
    tasks: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.GetTaskProtectionRequest = {
    import GetTaskProtectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.GetTaskProtectionRequest
      .builder()
      .cluster(cluster: java.lang.String)
      .optionallyWith(
        tasks.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tasks)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.GetTaskProtectionRequest.ReadOnly =
    zio.aws.ecs.model.GetTaskProtectionRequest.wrap(buildAwsValue())
}
object GetTaskProtectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.GetTaskProtectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.GetTaskProtectionRequest =
      zio.aws.ecs.model
        .GetTaskProtectionRequest(cluster, tasks.map(value => value))
    def cluster: String
    def tasks: Optional[List[String]]
    def getCluster: ZIO[Any, Nothing, String] = ZIO.succeed(cluster)
    def getTasks: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tasks", tasks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.GetTaskProtectionRequest
  ) extends zio.aws.ecs.model.GetTaskProtectionRequest.ReadOnly {
    override val cluster: String = impl.cluster(): String
    override val tasks: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tasks())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.GetTaskProtectionRequest
  ): zio.aws.ecs.model.GetTaskProtectionRequest.ReadOnly = new Wrapper(impl)
}
