package zio.aws.ecs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.BoxedInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class EFSVolumeConfiguration(
    fileSystemId: String,
    rootDirectory: Optional[String] = Optional.Absent,
    transitEncryption: Optional[zio.aws.ecs.model.EFSTransitEncryption] =
      Optional.Absent,
    transitEncryptionPort: Optional[BoxedInteger] = Optional.Absent,
    authorizationConfig: Optional[zio.aws.ecs.model.EFSAuthorizationConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.EFSVolumeConfiguration = {
    import EFSVolumeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.EFSVolumeConfiguration
      .builder()
      .fileSystemId(fileSystemId: java.lang.String)
      .optionallyWith(rootDirectory.map(value => value: java.lang.String))(
        _.rootDirectory
      )
      .optionallyWith(transitEncryption.map(value => value.unwrap))(
        _.transitEncryption
      )
      .optionallyWith(transitEncryptionPort.map(value => value: Integer))(
        _.transitEncryptionPort
      )
      .optionallyWith(authorizationConfig.map(value => value.buildAwsValue()))(
        _.authorizationConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.EFSVolumeConfiguration.ReadOnly =
    zio.aws.ecs.model.EFSVolumeConfiguration.wrap(buildAwsValue())
}
object EFSVolumeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.EFSVolumeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.EFSVolumeConfiguration =
      zio.aws.ecs.model.EFSVolumeConfiguration(
        fileSystemId,
        rootDirectory.map(value => value),
        transitEncryption.map(value => value),
        transitEncryptionPort.map(value => value),
        authorizationConfig.map(value => value.asEditable)
      )
    def fileSystemId: String
    def rootDirectory: Optional[String]
    def transitEncryption: Optional[zio.aws.ecs.model.EFSTransitEncryption]
    def transitEncryptionPort: Optional[BoxedInteger]
    def authorizationConfig
        : Optional[zio.aws.ecs.model.EFSAuthorizationConfig.ReadOnly]
    def getFileSystemId: ZIO[Any, Nothing, String] = ZIO.succeed(fileSystemId)
    def getRootDirectory: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("rootDirectory", rootDirectory)
    def getTransitEncryption
        : ZIO[Any, AwsError, zio.aws.ecs.model.EFSTransitEncryption] =
      AwsError.unwrapOptionField("transitEncryption", transitEncryption)
    def getTransitEncryptionPort: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("transitEncryptionPort", transitEncryptionPort)
    def getAuthorizationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.ecs.model.EFSAuthorizationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("authorizationConfig", authorizationConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.EFSVolumeConfiguration
  ) extends zio.aws.ecs.model.EFSVolumeConfiguration.ReadOnly {
    override val fileSystemId: String = impl.fileSystemId(): String
    override val rootDirectory: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.rootDirectory())
      .map(value => value: String)
    override val transitEncryption
        : Optional[zio.aws.ecs.model.EFSTransitEncryption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitEncryption())
        .map(value => zio.aws.ecs.model.EFSTransitEncryption.wrap(value))
    override val transitEncryptionPort: Optional[BoxedInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitEncryptionPort())
        .map(value => value: BoxedInteger)
    override val authorizationConfig
        : Optional[zio.aws.ecs.model.EFSAuthorizationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authorizationConfig())
        .map(value => zio.aws.ecs.model.EFSAuthorizationConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.EFSVolumeConfiguration
  ): zio.aws.ecs.model.EFSVolumeConfiguration.ReadOnly = new Wrapper(impl)
}
