package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Tag(
    key: Optional[TagKey] = Optional.Absent,
    value: Optional[TagValue] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.Tag
      .builder()
      .optionallyWith(key.map(value => TagKey.unwrap(value): java.lang.String))(
        _.key
      )
      .optionallyWith(
        value.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.Tag.ReadOnly =
    zio.aws.ecs.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.Tag =
      zio.aws.ecs.model.Tag(key.map(value => value), value.map(value => value))
    def key: Optional[TagKey]
    def value: Optional[TagValue]
    def getKey: ZIO[Any, AwsError, TagKey] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.Tag
  ) extends zio.aws.ecs.model.Tag.ReadOnly {
    override val key: Optional[TagKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.ecs.model.primitives.TagKey(value))
    override val value: Optional[TagValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.ecs.model.primitives.TagValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.Tag
  ): zio.aws.ecs.model.Tag.ReadOnly = new Wrapper(impl)
}
