package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ServiceConnectServiceResource(
    discoveryName: Optional[String] = Optional.Absent,
    discoveryArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ServiceConnectServiceResource = {
    import ServiceConnectServiceResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ServiceConnectServiceResource
      .builder()
      .optionallyWith(discoveryName.map(value => value: java.lang.String))(
        _.discoveryName
      )
      .optionallyWith(discoveryArn.map(value => value: java.lang.String))(
        _.discoveryArn
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ServiceConnectServiceResource.ReadOnly =
    zio.aws.ecs.model.ServiceConnectServiceResource.wrap(buildAwsValue())
}
object ServiceConnectServiceResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ServiceConnectServiceResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ServiceConnectServiceResource =
      zio.aws.ecs.model.ServiceConnectServiceResource(
        discoveryName.map(value => value),
        discoveryArn.map(value => value)
      )
    def discoveryName: Optional[String]
    def discoveryArn: Optional[String]
    def getDiscoveryName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("discoveryName", discoveryName)
    def getDiscoveryArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("discoveryArn", discoveryArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ServiceConnectServiceResource
  ) extends zio.aws.ecs.model.ServiceConnectServiceResource.ReadOnly {
    override val discoveryName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.discoveryName())
      .map(value => value: String)
    override val discoveryArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.discoveryArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ServiceConnectServiceResource
  ): zio.aws.ecs.model.ServiceConnectServiceResource.ReadOnly = new Wrapper(
    impl
  )
}
