package zio.aws.ecs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.BoxedInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTaskDefinitionFamiliesRequest(
    familyPrefix: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.ecs.model.TaskDefinitionFamilyStatus] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[BoxedInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesRequest = {
    import ListTaskDefinitionFamiliesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesRequest
      .builder()
      .optionallyWith(familyPrefix.map(value => value: java.lang.String))(
        _.familyPrefix
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ListTaskDefinitionFamiliesRequest.ReadOnly =
    zio.aws.ecs.model.ListTaskDefinitionFamiliesRequest.wrap(buildAwsValue())
}
object ListTaskDefinitionFamiliesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ListTaskDefinitionFamiliesRequest =
      zio.aws.ecs.model.ListTaskDefinitionFamiliesRequest(
        familyPrefix.map(value => value),
        status.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def familyPrefix: Optional[String]
    def status: Optional[zio.aws.ecs.model.TaskDefinitionFamilyStatus]
    def nextToken: Optional[String]
    def maxResults: Optional[BoxedInteger]
    def getFamilyPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("familyPrefix", familyPrefix)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ecs.model.TaskDefinitionFamilyStatus] =
      AwsError.unwrapOptionField("status", status)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesRequest
  ) extends zio.aws.ecs.model.ListTaskDefinitionFamiliesRequest.ReadOnly {
    override val familyPrefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.familyPrefix())
      .map(value => value: String)
    override val status
        : Optional[zio.aws.ecs.model.TaskDefinitionFamilyStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ecs.model.TaskDefinitionFamilyStatus.wrap(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: BoxedInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesRequest
  ): zio.aws.ecs.model.ListTaskDefinitionFamiliesRequest.ReadOnly = new Wrapper(
    impl
  )
}
