package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait Connectivity {
  def unwrap: software.amazon.awssdk.services.ecs.model.Connectivity
}
object Connectivity {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.Connectivity
  ): zio.aws.ecs.model.Connectivity = value match {
    case software.amazon.awssdk.services.ecs.model.Connectivity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.Connectivity.CONNECTED =>
      val r = CONNECTED
      r
    case software.amazon.awssdk.services.ecs.model.Connectivity.DISCONNECTED =>
      val r = DISCONNECTED
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.Connectivity {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.Connectivity =
      software.amazon.awssdk.services.ecs.model.Connectivity.UNKNOWN_TO_SDK_VERSION
  }
  case object CONNECTED extends zio.aws.ecs.model.Connectivity {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.Connectivity =
      software.amazon.awssdk.services.ecs.model.Connectivity.CONNECTED
  }
  case object DISCONNECTED extends zio.aws.ecs.model.Connectivity {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.Connectivity =
      software.amazon.awssdk.services.ecs.model.Connectivity.DISCONNECTED
  }
}
