package zio.aws.ecs.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class Task(
    attachments: Optional[Iterable[zio.aws.ecs.model.Attachment]] =
      Optional.Absent,
    attributes: Optional[Iterable[zio.aws.ecs.model.Attribute]] =
      Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    capacityProviderName: Optional[String] = Optional.Absent,
    clusterArn: Optional[String] = Optional.Absent,
    connectivity: Optional[zio.aws.ecs.model.Connectivity] = Optional.Absent,
    connectivityAt: Optional[Timestamp] = Optional.Absent,
    containerInstanceArn: Optional[String] = Optional.Absent,
    containers: Optional[Iterable[zio.aws.ecs.model.Container]] =
      Optional.Absent,
    cpu: Optional[String] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    desiredStatus: Optional[String] = Optional.Absent,
    enableExecuteCommand: Optional[Boolean] = Optional.Absent,
    executionStoppedAt: Optional[Timestamp] = Optional.Absent,
    group: Optional[String] = Optional.Absent,
    healthStatus: Optional[zio.aws.ecs.model.HealthStatus] = Optional.Absent,
    inferenceAccelerators: Optional[
      Iterable[zio.aws.ecs.model.InferenceAccelerator]
    ] = Optional.Absent,
    lastStatus: Optional[String] = Optional.Absent,
    launchType: Optional[zio.aws.ecs.model.LaunchType] = Optional.Absent,
    memory: Optional[String] = Optional.Absent,
    overrides: Optional[zio.aws.ecs.model.TaskOverride] = Optional.Absent,
    platformVersion: Optional[String] = Optional.Absent,
    platformFamily: Optional[String] = Optional.Absent,
    pullStartedAt: Optional[Timestamp] = Optional.Absent,
    pullStoppedAt: Optional[Timestamp] = Optional.Absent,
    startedAt: Optional[Timestamp] = Optional.Absent,
    startedBy: Optional[String] = Optional.Absent,
    stopCode: Optional[zio.aws.ecs.model.TaskStopCode] = Optional.Absent,
    stoppedAt: Optional[Timestamp] = Optional.Absent,
    stoppedReason: Optional[String] = Optional.Absent,
    stoppingAt: Optional[Timestamp] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ecs.model.Tag]] = Optional.Absent,
    taskArn: Optional[String] = Optional.Absent,
    taskDefinitionArn: Optional[String] = Optional.Absent,
    version: Optional[Long] = Optional.Absent,
    ephemeralStorage: Optional[zio.aws.ecs.model.EphemeralStorage] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.Task = {
    import Task.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.Task
      .builder()
      .optionallyWith(
        attachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachments)
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        capacityProviderName.map(value => value: java.lang.String)
      )(_.capacityProviderName)
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(connectivity.map(value => value.unwrap))(_.connectivity)
      .optionallyWith(
        connectivityAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.connectivityAt)
      .optionallyWith(
        containerInstanceArn.map(value => value: java.lang.String)
      )(_.containerInstanceArn)
      .optionallyWith(
        containers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containers)
      .optionallyWith(cpu.map(value => value: java.lang.String))(_.cpu)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(desiredStatus.map(value => value: java.lang.String))(
        _.desiredStatus
      )
      .optionallyWith(
        enableExecuteCommand.map(value => value: java.lang.Boolean)
      )(_.enableExecuteCommand)
      .optionallyWith(
        executionStoppedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.executionStoppedAt)
      .optionallyWith(group.map(value => value: java.lang.String))(_.group)
      .optionallyWith(healthStatus.map(value => value.unwrap))(_.healthStatus)
      .optionallyWith(
        inferenceAccelerators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inferenceAccelerators)
      .optionallyWith(lastStatus.map(value => value: java.lang.String))(
        _.lastStatus
      )
      .optionallyWith(launchType.map(value => value.unwrap))(_.launchType)
      .optionallyWith(memory.map(value => value: java.lang.String))(_.memory)
      .optionallyWith(overrides.map(value => value.buildAwsValue()))(
        _.overrides
      )
      .optionallyWith(platformVersion.map(value => value: java.lang.String))(
        _.platformVersion
      )
      .optionallyWith(platformFamily.map(value => value: java.lang.String))(
        _.platformFamily
      )
      .optionallyWith(
        pullStartedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.pullStartedAt)
      .optionallyWith(
        pullStoppedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.pullStoppedAt)
      .optionallyWith(startedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.startedAt
      )
      .optionallyWith(startedBy.map(value => value: java.lang.String))(
        _.startedBy
      )
      .optionallyWith(stopCode.map(value => value.unwrap))(_.stopCode)
      .optionallyWith(stoppedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.stoppedAt
      )
      .optionallyWith(stoppedReason.map(value => value: java.lang.String))(
        _.stoppedReason
      )
      .optionallyWith(
        stoppingAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.stoppingAt)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(taskArn.map(value => value: java.lang.String))(_.taskArn)
      .optionallyWith(taskDefinitionArn.map(value => value: java.lang.String))(
        _.taskDefinitionArn
      )
      .optionallyWith(version.map(value => value: java.lang.Long))(_.version)
      .optionallyWith(ephemeralStorage.map(value => value.buildAwsValue()))(
        _.ephemeralStorage
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.Task.ReadOnly =
    zio.aws.ecs.model.Task.wrap(buildAwsValue())
}
object Task {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.Task] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.Task = zio.aws.ecs.model.Task(
      attachments.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      attributes.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      availabilityZone.map(value => value),
      capacityProviderName.map(value => value),
      clusterArn.map(value => value),
      connectivity.map(value => value),
      connectivityAt.map(value => value),
      containerInstanceArn.map(value => value),
      containers.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      cpu.map(value => value),
      createdAt.map(value => value),
      desiredStatus.map(value => value),
      enableExecuteCommand.map(value => value),
      executionStoppedAt.map(value => value),
      group.map(value => value),
      healthStatus.map(value => value),
      inferenceAccelerators.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      lastStatus.map(value => value),
      launchType.map(value => value),
      memory.map(value => value),
      overrides.map(value => value.asEditable),
      platformVersion.map(value => value),
      platformFamily.map(value => value),
      pullStartedAt.map(value => value),
      pullStoppedAt.map(value => value),
      startedAt.map(value => value),
      startedBy.map(value => value),
      stopCode.map(value => value),
      stoppedAt.map(value => value),
      stoppedReason.map(value => value),
      stoppingAt.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      taskArn.map(value => value),
      taskDefinitionArn.map(value => value),
      version.map(value => value),
      ephemeralStorage.map(value => value.asEditable)
    )
    def attachments: Optional[List[zio.aws.ecs.model.Attachment.ReadOnly]]
    def attributes: Optional[List[zio.aws.ecs.model.Attribute.ReadOnly]]
    def availabilityZone: Optional[String]
    def capacityProviderName: Optional[String]
    def clusterArn: Optional[String]
    def connectivity: Optional[zio.aws.ecs.model.Connectivity]
    def connectivityAt: Optional[Timestamp]
    def containerInstanceArn: Optional[String]
    def containers: Optional[List[zio.aws.ecs.model.Container.ReadOnly]]
    def cpu: Optional[String]
    def createdAt: Optional[Timestamp]
    def desiredStatus: Optional[String]
    def enableExecuteCommand: Optional[Boolean]
    def executionStoppedAt: Optional[Timestamp]
    def group: Optional[String]
    def healthStatus: Optional[zio.aws.ecs.model.HealthStatus]
    def inferenceAccelerators
        : Optional[List[zio.aws.ecs.model.InferenceAccelerator.ReadOnly]]
    def lastStatus: Optional[String]
    def launchType: Optional[zio.aws.ecs.model.LaunchType]
    def memory: Optional[String]
    def overrides: Optional[zio.aws.ecs.model.TaskOverride.ReadOnly]
    def platformVersion: Optional[String]
    def platformFamily: Optional[String]
    def pullStartedAt: Optional[Timestamp]
    def pullStoppedAt: Optional[Timestamp]
    def startedAt: Optional[Timestamp]
    def startedBy: Optional[String]
    def stopCode: Optional[zio.aws.ecs.model.TaskStopCode]
    def stoppedAt: Optional[Timestamp]
    def stoppedReason: Optional[String]
    def stoppingAt: Optional[Timestamp]
    def tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]]
    def taskArn: Optional[String]
    def taskDefinitionArn: Optional[String]
    def version: Optional[Long]
    def ephemeralStorage: Optional[zio.aws.ecs.model.EphemeralStorage.ReadOnly]
    def getAttachments
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Attachment.ReadOnly]] =
      AwsError.unwrapOptionField("attachments", attachments)
    def getAttributes
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Attribute.ReadOnly]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getCapacityProviderName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("capacityProviderName", capacityProviderName)
    def getClusterArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getConnectivity: ZIO[Any, AwsError, zio.aws.ecs.model.Connectivity] =
      AwsError.unwrapOptionField("connectivity", connectivity)
    def getConnectivityAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("connectivityAt", connectivityAt)
    def getContainerInstanceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerInstanceArn", containerInstanceArn)
    def getContainers
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Container.ReadOnly]] =
      AwsError.unwrapOptionField("containers", containers)
    def getCpu: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cpu", cpu)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDesiredStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("desiredStatus", desiredStatus)
    def getEnableExecuteCommand: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableExecuteCommand", enableExecuteCommand)
    def getExecutionStoppedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("executionStoppedAt", executionStoppedAt)
    def getGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("group", group)
    def getHealthStatus: ZIO[Any, AwsError, zio.aws.ecs.model.HealthStatus] =
      AwsError.unwrapOptionField("healthStatus", healthStatus)
    def getInferenceAccelerators: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.InferenceAccelerator.ReadOnly
    ]] =
      AwsError.unwrapOptionField("inferenceAccelerators", inferenceAccelerators)
    def getLastStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastStatus", lastStatus)
    def getLaunchType: ZIO[Any, AwsError, zio.aws.ecs.model.LaunchType] =
      AwsError.unwrapOptionField("launchType", launchType)
    def getMemory: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("memory", memory)
    def getOverrides
        : ZIO[Any, AwsError, zio.aws.ecs.model.TaskOverride.ReadOnly] =
      AwsError.unwrapOptionField("overrides", overrides)
    def getPlatformVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getPlatformFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformFamily", platformFamily)
    def getPullStartedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("pullStartedAt", pullStartedAt)
    def getPullStoppedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("pullStoppedAt", pullStoppedAt)
    def getStartedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getStartedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("startedBy", startedBy)
    def getStopCode: ZIO[Any, AwsError, zio.aws.ecs.model.TaskStopCode] =
      AwsError.unwrapOptionField("stopCode", stopCode)
    def getStoppedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("stoppedAt", stoppedAt)
    def getStoppedReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stoppedReason", stoppedReason)
    def getStoppingAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("stoppingAt", stoppingAt)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTaskArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskArn", taskArn)
    def getTaskDefinitionArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskDefinitionArn", taskDefinitionArn)
    def getVersion: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("version", version)
    def getEphemeralStorage
        : ZIO[Any, AwsError, zio.aws.ecs.model.EphemeralStorage.ReadOnly] =
      AwsError.unwrapOptionField("ephemeralStorage", ephemeralStorage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.Task
  ) extends zio.aws.ecs.model.Task.ReadOnly {
    override val attachments
        : Optional[List[zio.aws.ecs.model.Attachment.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Attachment.wrap(item)
          }.toList
        )
    override val attributes
        : Optional[List[zio.aws.ecs.model.Attribute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Attribute.wrap(item)
          }.toList
        )
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val capacityProviderName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityProviderName())
      .map(value => value: String)
    override val clusterArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterArn())
      .map(value => value: String)
    override val connectivity: Optional[zio.aws.ecs.model.Connectivity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectivity())
        .map(value => zio.aws.ecs.model.Connectivity.wrap(value))
    override val connectivityAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.connectivityAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val containerInstanceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.containerInstanceArn())
      .map(value => value: String)
    override val containers
        : Optional[List[zio.aws.ecs.model.Container.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Container.wrap(item)
          }.toList
        )
    override val cpu: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cpu())
      .map(value => value: String)
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val desiredStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.desiredStatus())
      .map(value => value: String)
    override val enableExecuteCommand: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enableExecuteCommand())
      .map(value => value: Boolean)
    override val executionStoppedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.executionStoppedAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val group: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.group())
      .map(value => value: String)
    override val healthStatus: Optional[zio.aws.ecs.model.HealthStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthStatus())
        .map(value => zio.aws.ecs.model.HealthStatus.wrap(value))
    override val inferenceAccelerators
        : Optional[List[zio.aws.ecs.model.InferenceAccelerator.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inferenceAccelerators())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.InferenceAccelerator.wrap(item)
          }.toList
        )
    override val lastStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastStatus())
      .map(value => value: String)
    override val launchType: Optional[zio.aws.ecs.model.LaunchType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchType())
        .map(value => zio.aws.ecs.model.LaunchType.wrap(value))
    override val memory: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.memory())
      .map(value => value: String)
    override val overrides: Optional[zio.aws.ecs.model.TaskOverride.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.overrides())
        .map(value => zio.aws.ecs.model.TaskOverride.wrap(value))
    override val platformVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platformVersion())
      .map(value => value: String)
    override val platformFamily: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platformFamily())
      .map(value => value: String)
    override val pullStartedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.pullStartedAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val pullStoppedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.pullStoppedAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val startedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val startedBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.startedBy())
      .map(value => value: String)
    override val stopCode: Optional[zio.aws.ecs.model.TaskStopCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stopCode())
        .map(value => zio.aws.ecs.model.TaskStopCode.wrap(value))
    override val stoppedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.stoppedAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val stoppedReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stoppedReason())
      .map(value => value: String)
    override val stoppingAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.stoppingAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Tag.wrap(item)
          }.toList
        )
    override val taskArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.taskArn())
      .map(value => value: String)
    override val taskDefinitionArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.taskDefinitionArn())
      .map(value => value: String)
    override val version: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: Long)
    override val ephemeralStorage
        : Optional[zio.aws.ecs.model.EphemeralStorage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ephemeralStorage())
        .map(value => zio.aws.ecs.model.EphemeralStorage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.Task
  ): zio.aws.ecs.model.Task.ReadOnly = new Wrapper(impl)
}
