package zio.aws.ecs.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class SubmitTaskStateChangeRequest(
    cluster: Optional[String] = Optional.Absent,
    task: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    reason: Optional[String] = Optional.Absent,
    containers: Optional[Iterable[zio.aws.ecs.model.ContainerStateChange]] =
      Optional.Absent,
    attachments: Optional[Iterable[zio.aws.ecs.model.AttachmentStateChange]] =
      Optional.Absent,
    managedAgents: Optional[
      Iterable[zio.aws.ecs.model.ManagedAgentStateChange]
    ] = Optional.Absent,
    pullStartedAt: Optional[Timestamp] = Optional.Absent,
    pullStoppedAt: Optional[Timestamp] = Optional.Absent,
    executionStoppedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.SubmitTaskStateChangeRequest = {
    import SubmitTaskStateChangeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.SubmitTaskStateChangeRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .optionallyWith(task.map(value => value: java.lang.String))(_.task)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .optionallyWith(
        containers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containers)
      .optionallyWith(
        attachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachments)
      .optionallyWith(
        managedAgents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.managedAgents)
      .optionallyWith(
        pullStartedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.pullStartedAt)
      .optionallyWith(
        pullStoppedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.pullStoppedAt)
      .optionallyWith(
        executionStoppedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.executionStoppedAt)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.SubmitTaskStateChangeRequest.ReadOnly =
    zio.aws.ecs.model.SubmitTaskStateChangeRequest.wrap(buildAwsValue())
}
object SubmitTaskStateChangeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.SubmitTaskStateChangeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.SubmitTaskStateChangeRequest =
      zio.aws.ecs.model.SubmitTaskStateChangeRequest(
        cluster.map(value => value),
        task.map(value => value),
        status.map(value => value),
        reason.map(value => value),
        containers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        attachments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        managedAgents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        pullStartedAt.map(value => value),
        pullStoppedAt.map(value => value),
        executionStoppedAt.map(value => value)
      )
    def cluster: Optional[String]
    def task: Optional[String]
    def status: Optional[String]
    def reason: Optional[String]
    def containers
        : Optional[List[zio.aws.ecs.model.ContainerStateChange.ReadOnly]]
    def attachments
        : Optional[List[zio.aws.ecs.model.AttachmentStateChange.ReadOnly]]
    def managedAgents
        : Optional[List[zio.aws.ecs.model.ManagedAgentStateChange.ReadOnly]]
    def pullStartedAt: Optional[Timestamp]
    def pullStoppedAt: Optional[Timestamp]
    def executionStoppedAt: Optional[Timestamp]
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getTask: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("task", task)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
    def getContainers: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.ContainerStateChange.ReadOnly
    ]] = AwsError.unwrapOptionField("containers", containers)
    def getAttachments: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.AttachmentStateChange.ReadOnly
    ]] = AwsError.unwrapOptionField("attachments", attachments)
    def getManagedAgents: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.ManagedAgentStateChange.ReadOnly
    ]] = AwsError.unwrapOptionField("managedAgents", managedAgents)
    def getPullStartedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("pullStartedAt", pullStartedAt)
    def getPullStoppedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("pullStoppedAt", pullStoppedAt)
    def getExecutionStoppedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("executionStoppedAt", executionStoppedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.SubmitTaskStateChangeRequest
  ) extends zio.aws.ecs.model.SubmitTaskStateChangeRequest.ReadOnly {
    override val cluster: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cluster())
      .map(value => value: String)
    override val task: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.task())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val reason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => value: String)
    override val containers
        : Optional[List[zio.aws.ecs.model.ContainerStateChange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.ContainerStateChange.wrap(item)
          }.toList
        )
    override val attachments
        : Optional[List[zio.aws.ecs.model.AttachmentStateChange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.AttachmentStateChange.wrap(item)
          }.toList
        )
    override val managedAgents
        : Optional[List[zio.aws.ecs.model.ManagedAgentStateChange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedAgents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.ManagedAgentStateChange.wrap(item)
          }.toList
        )
    override val pullStartedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.pullStartedAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val pullStoppedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.pullStoppedAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val executionStoppedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.executionStoppedAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.SubmitTaskStateChangeRequest
  ): zio.aws.ecs.model.SubmitTaskStateChangeRequest.ReadOnly = new Wrapper(impl)
}
