package zio.aws.ecs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.BoxedInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ContainerOverride(
    name: Optional[String] = Optional.Absent,
    command: Optional[Iterable[String]] = Optional.Absent,
    environment: Optional[Iterable[zio.aws.ecs.model.KeyValuePair]] =
      Optional.Absent,
    environmentFiles: Optional[Iterable[zio.aws.ecs.model.EnvironmentFile]] =
      Optional.Absent,
    cpu: Optional[BoxedInteger] = Optional.Absent,
    memory: Optional[BoxedInteger] = Optional.Absent,
    memoryReservation: Optional[BoxedInteger] = Optional.Absent,
    resourceRequirements: Optional[
      Iterable[zio.aws.ecs.model.ResourceRequirement]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ContainerOverride = {
    import ContainerOverride.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ContainerOverride
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        command.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.command)
      .optionallyWith(
        environment.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environment)
      .optionallyWith(
        environmentFiles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environmentFiles)
      .optionallyWith(cpu.map(value => value: Integer))(_.cpu)
      .optionallyWith(memory.map(value => value: Integer))(_.memory)
      .optionallyWith(memoryReservation.map(value => value: Integer))(
        _.memoryReservation
      )
      .optionallyWith(
        resourceRequirements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceRequirements)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ContainerOverride.ReadOnly =
    zio.aws.ecs.model.ContainerOverride.wrap(buildAwsValue())
}
object ContainerOverride {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ContainerOverride
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ContainerOverride =
      zio.aws.ecs.model.ContainerOverride(
        name.map(value => value),
        command.map(value => value),
        environment.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        environmentFiles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cpu.map(value => value),
        memory.map(value => value),
        memoryReservation.map(value => value),
        resourceRequirements.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Optional[String]
    def command: Optional[List[String]]
    def environment: Optional[List[zio.aws.ecs.model.KeyValuePair.ReadOnly]]
    def environmentFiles
        : Optional[List[zio.aws.ecs.model.EnvironmentFile.ReadOnly]]
    def cpu: Optional[BoxedInteger]
    def memory: Optional[BoxedInteger]
    def memoryReservation: Optional[BoxedInteger]
    def resourceRequirements
        : Optional[List[zio.aws.ecs.model.ResourceRequirement.ReadOnly]]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getCommand: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("command", command)
    def getEnvironment
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.KeyValuePair.ReadOnly]] =
      AwsError.unwrapOptionField("environment", environment)
    def getEnvironmentFiles
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.EnvironmentFile.ReadOnly]] =
      AwsError.unwrapOptionField("environmentFiles", environmentFiles)
    def getCpu: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("cpu", cpu)
    def getMemory: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("memory", memory)
    def getMemoryReservation: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("memoryReservation", memoryReservation)
    def getResourceRequirements: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.ResourceRequirement.ReadOnly
    ]] =
      AwsError.unwrapOptionField("resourceRequirements", resourceRequirements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ContainerOverride
  ) extends zio.aws.ecs.model.ContainerOverride.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val command: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.command())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val environment
        : Optional[List[zio.aws.ecs.model.KeyValuePair.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.KeyValuePair.wrap(item)
          }.toList
        )
    override val environmentFiles
        : Optional[List[zio.aws.ecs.model.EnvironmentFile.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentFiles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.EnvironmentFile.wrap(item)
          }.toList
        )
    override val cpu: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.cpu())
      .map(value => value: BoxedInteger)
    override val memory: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.memory())
      .map(value => value: BoxedInteger)
    override val memoryReservation: Optional[BoxedInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.memoryReservation())
        .map(value => value: BoxedInteger)
    override val resourceRequirements
        : Optional[List[zio.aws.ecs.model.ResourceRequirement.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceRequirements())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.ResourceRequirement.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ContainerOverride
  ): zio.aws.ecs.model.ContainerOverride.ReadOnly = new Wrapper(impl)
}
