package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait LaunchType {
  def unwrap: software.amazon.awssdk.services.ecs.model.LaunchType
}
object LaunchType {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.LaunchType
  ): zio.aws.ecs.model.LaunchType = value match {
    case software.amazon.awssdk.services.ecs.model.LaunchType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.LaunchType.EC2 =>
      val r = EC2
      r
    case software.amazon.awssdk.services.ecs.model.LaunchType.FARGATE =>
      val r = FARGATE
      r
    case software.amazon.awssdk.services.ecs.model.LaunchType.EXTERNAL =>
      val r = EXTERNAL
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.LaunchType {
    override def unwrap: software.amazon.awssdk.services.ecs.model.LaunchType =
      software.amazon.awssdk.services.ecs.model.LaunchType.UNKNOWN_TO_SDK_VERSION
  }
  case object EC2 extends zio.aws.ecs.model.LaunchType {
    override def unwrap: software.amazon.awssdk.services.ecs.model.LaunchType =
      software.amazon.awssdk.services.ecs.model.LaunchType.EC2
  }
  case object FARGATE extends zio.aws.ecs.model.LaunchType {
    override def unwrap: software.amazon.awssdk.services.ecs.model.LaunchType =
      software.amazon.awssdk.services.ecs.model.LaunchType.FARGATE
  }
  case object EXTERNAL extends zio.aws.ecs.model.LaunchType {
    override def unwrap: software.amazon.awssdk.services.ecs.model.LaunchType =
      software.amazon.awssdk.services.ecs.model.LaunchType.EXTERNAL
  }
}
