package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeCapacityProvidersResponse(
    capacityProviders: Optional[Iterable[zio.aws.ecs.model.CapacityProvider]] =
      Optional.Absent,
    failures: Optional[Iterable[zio.aws.ecs.model.Failure]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DescribeCapacityProvidersResponse = {
    import DescribeCapacityProvidersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DescribeCapacityProvidersResponse
      .builder()
      .optionallyWith(
        capacityProviders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.capacityProviders)
      .optionallyWith(
        failures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failures)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DescribeCapacityProvidersResponse.ReadOnly =
    zio.aws.ecs.model.DescribeCapacityProvidersResponse.wrap(buildAwsValue())
}
object DescribeCapacityProvidersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DescribeCapacityProvidersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DescribeCapacityProvidersResponse =
      zio.aws.ecs.model.DescribeCapacityProvidersResponse(
        capacityProviders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failures.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def capacityProviders
        : Optional[List[zio.aws.ecs.model.CapacityProvider.ReadOnly]]
    def failures: Optional[List[zio.aws.ecs.model.Failure.ReadOnly]]
    def nextToken: Optional[String]
    def getCapacityProviders: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.CapacityProvider.ReadOnly
    ]] = AwsError.unwrapOptionField("capacityProviders", capacityProviders)
    def getFailures
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Failure.ReadOnly]] =
      AwsError.unwrapOptionField("failures", failures)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DescribeCapacityProvidersResponse
  ) extends zio.aws.ecs.model.DescribeCapacityProvidersResponse.ReadOnly {
    override val capacityProviders
        : Optional[List[zio.aws.ecs.model.CapacityProvider.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityProviders())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.CapacityProvider.wrap(item)
          }.toList
        )
    override val failures: Optional[List[zio.aws.ecs.model.Failure.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Failure.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DescribeCapacityProvidersResponse
  ): zio.aws.ecs.model.DescribeCapacityProvidersResponse.ReadOnly = new Wrapper(
    impl
  )
}
