package zio.aws.ecs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.BoxedInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class LoadBalancer(
    targetGroupArn: Optional[String] = Optional.Absent,
    loadBalancerName: Optional[String] = Optional.Absent,
    containerName: Optional[String] = Optional.Absent,
    containerPort: Optional[BoxedInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.LoadBalancer = {
    import LoadBalancer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.LoadBalancer
      .builder()
      .optionallyWith(targetGroupArn.map(value => value: java.lang.String))(
        _.targetGroupArn
      )
      .optionallyWith(loadBalancerName.map(value => value: java.lang.String))(
        _.loadBalancerName
      )
      .optionallyWith(containerName.map(value => value: java.lang.String))(
        _.containerName
      )
      .optionallyWith(containerPort.map(value => value: Integer))(
        _.containerPort
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.LoadBalancer.ReadOnly =
    zio.aws.ecs.model.LoadBalancer.wrap(buildAwsValue())
}
object LoadBalancer {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.LoadBalancer] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.LoadBalancer =
      zio.aws.ecs.model.LoadBalancer(
        targetGroupArn.map(value => value),
        loadBalancerName.map(value => value),
        containerName.map(value => value),
        containerPort.map(value => value)
      )
    def targetGroupArn: Optional[String]
    def loadBalancerName: Optional[String]
    def containerName: Optional[String]
    def containerPort: Optional[BoxedInteger]
    def getTargetGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetGroupArn", targetGroupArn)
    def getLoadBalancerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("loadBalancerName", loadBalancerName)
    def getContainerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerName", containerName)
    def getContainerPort: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("containerPort", containerPort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.LoadBalancer
  ) extends zio.aws.ecs.model.LoadBalancer.ReadOnly {
    override val targetGroupArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetGroupArn())
      .map(value => value: String)
    override val loadBalancerName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.loadBalancerName())
      .map(value => value: String)
    override val containerName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.containerName())
      .map(value => value: String)
    override val containerPort: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.containerPort())
      .map(value => value: BoxedInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.LoadBalancer
  ): zio.aws.ecs.model.LoadBalancer.ReadOnly = new Wrapper(impl)
}
