package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait ScaleUnit {
  def unwrap: software.amazon.awssdk.services.ecs.model.ScaleUnit
}
object ScaleUnit {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.ScaleUnit
  ): zio.aws.ecs.model.ScaleUnit = value match {
    case software.amazon.awssdk.services.ecs.model.ScaleUnit.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.ScaleUnit.PERCENT =>
      val r = PERCENT
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.ScaleUnit {
    override def unwrap: software.amazon.awssdk.services.ecs.model.ScaleUnit =
      software.amazon.awssdk.services.ecs.model.ScaleUnit.UNKNOWN_TO_SDK_VERSION
  }
  case object PERCENT extends zio.aws.ecs.model.ScaleUnit {
    override def unwrap: software.amazon.awssdk.services.ecs.model.ScaleUnit =
      software.amazon.awssdk.services.ecs.model.ScaleUnit.PERCENT
  }
}
