package zio.aws.ecs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.BoxedInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListContainerInstancesRequest(
    cluster: Optional[String] = Optional.Absent,
    filter: Optional[String] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[BoxedInteger] = Optional.Absent,
    status: Optional[zio.aws.ecs.model.ContainerInstanceStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ListContainerInstancesRequest = {
    import ListContainerInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ListContainerInstancesRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .optionallyWith(filter.map(value => value: java.lang.String))(_.filter)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ListContainerInstancesRequest.ReadOnly =
    zio.aws.ecs.model.ListContainerInstancesRequest.wrap(buildAwsValue())
}
object ListContainerInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ListContainerInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ListContainerInstancesRequest =
      zio.aws.ecs.model.ListContainerInstancesRequest(
        cluster.map(value => value),
        filter.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        status.map(value => value)
      )
    def cluster: Optional[String]
    def filter: Optional[String]
    def nextToken: Optional[String]
    def maxResults: Optional[BoxedInteger]
    def status: Optional[zio.aws.ecs.model.ContainerInstanceStatus]
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getFilter: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("filter", filter)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ecs.model.ContainerInstanceStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ListContainerInstancesRequest
  ) extends zio.aws.ecs.model.ListContainerInstancesRequest.ReadOnly {
    override val cluster: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cluster())
      .map(value => value: String)
    override val filter: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.filter())
      .map(value => value: String)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: BoxedInteger)
    override val status: Optional[zio.aws.ecs.model.ContainerInstanceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ecs.model.ContainerInstanceStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ListContainerInstancesRequest
  ): zio.aws.ecs.model.ListContainerInstancesRequest.ReadOnly = new Wrapper(
    impl
  )
}
