package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoScalingGroupProvider(
    autoScalingGroupArn: String,
    managedScaling: Optional[zio.aws.ecs.model.ManagedScaling] =
      Optional.Absent,
    managedTerminationProtection: Optional[
      zio.aws.ecs.model.ManagedTerminationProtection
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.AutoScalingGroupProvider = {
    import AutoScalingGroupProvider.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.AutoScalingGroupProvider
      .builder()
      .autoScalingGroupArn(autoScalingGroupArn: java.lang.String)
      .optionallyWith(managedScaling.map(value => value.buildAwsValue()))(
        _.managedScaling
      )
      .optionallyWith(managedTerminationProtection.map(value => value.unwrap))(
        _.managedTerminationProtection
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.AutoScalingGroupProvider.ReadOnly =
    zio.aws.ecs.model.AutoScalingGroupProvider.wrap(buildAwsValue())
}
object AutoScalingGroupProvider {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.AutoScalingGroupProvider
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.AutoScalingGroupProvider =
      zio.aws.ecs.model.AutoScalingGroupProvider(
        autoScalingGroupArn,
        managedScaling.map(value => value.asEditable),
        managedTerminationProtection.map(value => value)
      )
    def autoScalingGroupArn: String
    def managedScaling: Optional[zio.aws.ecs.model.ManagedScaling.ReadOnly]
    def managedTerminationProtection
        : Optional[zio.aws.ecs.model.ManagedTerminationProtection]
    def getAutoScalingGroupArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(autoScalingGroupArn)
    def getManagedScaling
        : ZIO[Any, AwsError, zio.aws.ecs.model.ManagedScaling.ReadOnly] =
      AwsError.unwrapOptionField("managedScaling", managedScaling)
    def getManagedTerminationProtection
        : ZIO[Any, AwsError, zio.aws.ecs.model.ManagedTerminationProtection] =
      AwsError.unwrapOptionField(
        "managedTerminationProtection",
        managedTerminationProtection
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.AutoScalingGroupProvider
  ) extends zio.aws.ecs.model.AutoScalingGroupProvider.ReadOnly {
    override val autoScalingGroupArn: String =
      impl.autoScalingGroupArn(): String
    override val managedScaling
        : Optional[zio.aws.ecs.model.ManagedScaling.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedScaling())
        .map(value => zio.aws.ecs.model.ManagedScaling.wrap(value))
    override val managedTerminationProtection
        : Optional[zio.aws.ecs.model.ManagedTerminationProtection] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedTerminationProtection())
        .map(value =>
          zio.aws.ecs.model.ManagedTerminationProtection.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.AutoScalingGroupProvider
  ): zio.aws.ecs.model.AutoScalingGroupProvider.ReadOnly = new Wrapper(impl)
}
