package zio.aws.ecs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.BoxedInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateServiceRequest(
    cluster: Optional[String] = Optional.Absent,
    serviceName: String,
    taskDefinition: Optional[String] = Optional.Absent,
    loadBalancers: Optional[Iterable[zio.aws.ecs.model.LoadBalancer]] =
      Optional.Absent,
    serviceRegistries: Optional[Iterable[zio.aws.ecs.model.ServiceRegistry]] =
      Optional.Absent,
    desiredCount: Optional[BoxedInteger] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    launchType: Optional[zio.aws.ecs.model.LaunchType] = Optional.Absent,
    capacityProviderStrategy: Optional[
      Iterable[zio.aws.ecs.model.CapacityProviderStrategyItem]
    ] = Optional.Absent,
    platformVersion: Optional[String] = Optional.Absent,
    role: Optional[String] = Optional.Absent,
    deploymentConfiguration: Optional[
      zio.aws.ecs.model.DeploymentConfiguration
    ] = Optional.Absent,
    placementConstraints: Optional[
      Iterable[zio.aws.ecs.model.PlacementConstraint]
    ] = Optional.Absent,
    placementStrategy: Optional[Iterable[zio.aws.ecs.model.PlacementStrategy]] =
      Optional.Absent,
    networkConfiguration: Optional[zio.aws.ecs.model.NetworkConfiguration] =
      Optional.Absent,
    healthCheckGracePeriodSeconds: Optional[BoxedInteger] = Optional.Absent,
    schedulingStrategy: Optional[zio.aws.ecs.model.SchedulingStrategy] =
      Optional.Absent,
    deploymentController: Optional[zio.aws.ecs.model.DeploymentController] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.ecs.model.Tag]] = Optional.Absent,
    enableECSManagedTags: Optional[Boolean] = Optional.Absent,
    propagateTags: Optional[zio.aws.ecs.model.PropagateTags] = Optional.Absent,
    enableExecuteCommand: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.CreateServiceRequest = {
    import CreateServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.CreateServiceRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .serviceName(serviceName: java.lang.String)
      .optionallyWith(taskDefinition.map(value => value: java.lang.String))(
        _.taskDefinition
      )
      .optionallyWith(
        loadBalancers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loadBalancers)
      .optionallyWith(
        serviceRegistries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceRegistries)
      .optionallyWith(desiredCount.map(value => value: Integer))(_.desiredCount)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(launchType.map(value => value.unwrap))(_.launchType)
      .optionallyWith(
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.capacityProviderStrategy)
      .optionallyWith(platformVersion.map(value => value: java.lang.String))(
        _.platformVersion
      )
      .optionallyWith(role.map(value => value: java.lang.String))(_.role)
      .optionallyWith(
        deploymentConfiguration.map(value => value.buildAwsValue())
      )(_.deploymentConfiguration)
      .optionallyWith(
        placementConstraints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementConstraints)
      .optionallyWith(
        placementStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementStrategy)
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .optionallyWith(
        healthCheckGracePeriodSeconds.map(value => value: Integer)
      )(_.healthCheckGracePeriodSeconds)
      .optionallyWith(schedulingStrategy.map(value => value.unwrap))(
        _.schedulingStrategy
      )
      .optionallyWith(deploymentController.map(value => value.buildAwsValue()))(
        _.deploymentController
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        enableECSManagedTags.map(value => value: java.lang.Boolean)
      )(_.enableECSManagedTags)
      .optionallyWith(propagateTags.map(value => value.unwrap))(_.propagateTags)
      .optionallyWith(
        enableExecuteCommand.map(value => value: java.lang.Boolean)
      )(_.enableExecuteCommand)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.CreateServiceRequest.ReadOnly =
    zio.aws.ecs.model.CreateServiceRequest.wrap(buildAwsValue())
}
object CreateServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.CreateServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.CreateServiceRequest =
      zio.aws.ecs.model.CreateServiceRequest(
        cluster.map(value => value),
        serviceName,
        taskDefinition.map(value => value),
        loadBalancers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        serviceRegistries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        desiredCount.map(value => value),
        clientToken.map(value => value),
        launchType.map(value => value),
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        platformVersion.map(value => value),
        role.map(value => value),
        deploymentConfiguration.map(value => value.asEditable),
        placementConstraints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        placementStrategy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkConfiguration.map(value => value.asEditable),
        healthCheckGracePeriodSeconds.map(value => value),
        schedulingStrategy.map(value => value),
        deploymentController.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        enableECSManagedTags.map(value => value),
        propagateTags.map(value => value),
        enableExecuteCommand.map(value => value)
      )
    def cluster: Optional[String]
    def serviceName: String
    def taskDefinition: Optional[String]
    def loadBalancers: Optional[List[zio.aws.ecs.model.LoadBalancer.ReadOnly]]
    def serviceRegistries
        : Optional[List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]]
    def desiredCount: Optional[BoxedInteger]
    def clientToken: Optional[String]
    def launchType: Optional[zio.aws.ecs.model.LaunchType]
    def capacityProviderStrategy: Optional[
      List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]
    ]
    def platformVersion: Optional[String]
    def role: Optional[String]
    def deploymentConfiguration
        : Optional[zio.aws.ecs.model.DeploymentConfiguration.ReadOnly]
    def placementConstraints
        : Optional[List[zio.aws.ecs.model.PlacementConstraint.ReadOnly]]
    def placementStrategy
        : Optional[List[zio.aws.ecs.model.PlacementStrategy.ReadOnly]]
    def networkConfiguration
        : Optional[zio.aws.ecs.model.NetworkConfiguration.ReadOnly]
    def healthCheckGracePeriodSeconds: Optional[BoxedInteger]
    def schedulingStrategy: Optional[zio.aws.ecs.model.SchedulingStrategy]
    def deploymentController
        : Optional[zio.aws.ecs.model.DeploymentController.ReadOnly]
    def tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]]
    def enableECSManagedTags: Optional[Boolean]
    def propagateTags: Optional[zio.aws.ecs.model.PropagateTags]
    def enableExecuteCommand: Optional[Boolean]
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getServiceName: ZIO[Any, Nothing, String] = ZIO.succeed(serviceName)
    def getTaskDefinition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskDefinition", taskDefinition)
    def getLoadBalancers
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.LoadBalancer.ReadOnly]] =
      AwsError.unwrapOptionField("loadBalancers", loadBalancers)
    def getServiceRegistries
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]] =
      AwsError.unwrapOptionField("serviceRegistries", serviceRegistries)
    def getDesiredCount: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("desiredCount", desiredCount)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getLaunchType: ZIO[Any, AwsError, zio.aws.ecs.model.LaunchType] =
      AwsError.unwrapOptionField("launchType", launchType)
    def getCapacityProviderStrategy: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "capacityProviderStrategy",
      capacityProviderStrategy
    )
    def getPlatformVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getRole: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("role", role)
    def getDeploymentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ecs.model.DeploymentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deploymentConfiguration",
      deploymentConfiguration
    )
    def getPlacementConstraints: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.PlacementConstraint.ReadOnly
    ]] =
      AwsError.unwrapOptionField("placementConstraints", placementConstraints)
    def getPlacementStrategy: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.PlacementStrategy.ReadOnly
    ]] = AwsError.unwrapOptionField("placementStrategy", placementStrategy)
    def getNetworkConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.NetworkConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
    def getHealthCheckGracePeriodSeconds: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField(
        "healthCheckGracePeriodSeconds",
        healthCheckGracePeriodSeconds
      )
    def getSchedulingStrategy
        : ZIO[Any, AwsError, zio.aws.ecs.model.SchedulingStrategy] =
      AwsError.unwrapOptionField("schedulingStrategy", schedulingStrategy)
    def getDeploymentController
        : ZIO[Any, AwsError, zio.aws.ecs.model.DeploymentController.ReadOnly] =
      AwsError.unwrapOptionField("deploymentController", deploymentController)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getEnableECSManagedTags: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableECSManagedTags", enableECSManagedTags)
    def getPropagateTags: ZIO[Any, AwsError, zio.aws.ecs.model.PropagateTags] =
      AwsError.unwrapOptionField("propagateTags", propagateTags)
    def getEnableExecuteCommand: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableExecuteCommand", enableExecuteCommand)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.CreateServiceRequest
  ) extends zio.aws.ecs.model.CreateServiceRequest.ReadOnly {
    override val cluster: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cluster())
      .map(value => value: String)
    override val serviceName: String = impl.serviceName(): String
    override val taskDefinition: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.taskDefinition())
      .map(value => value: String)
    override val loadBalancers
        : Optional[List[zio.aws.ecs.model.LoadBalancer.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.LoadBalancer.wrap(item)
          }.toList
        )
    override val serviceRegistries
        : Optional[List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceRegistries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.ServiceRegistry.wrap(item)
          }.toList
        )
    override val desiredCount: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.desiredCount())
      .map(value => value: BoxedInteger)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val launchType: Optional[zio.aws.ecs.model.LaunchType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchType())
        .map(value => zio.aws.ecs.model.LaunchType.wrap(value))
    override val capacityProviderStrategy: Optional[
      List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityProviderStrategy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.CapacityProviderStrategyItem.wrap(item)
        }.toList
      )
    override val platformVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platformVersion())
      .map(value => value: String)
    override val role: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.role())
      .map(value => value: String)
    override val deploymentConfiguration
        : Optional[zio.aws.ecs.model.DeploymentConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentConfiguration())
        .map(value => zio.aws.ecs.model.DeploymentConfiguration.wrap(value))
    override val placementConstraints
        : Optional[List[zio.aws.ecs.model.PlacementConstraint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placementConstraints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.PlacementConstraint.wrap(item)
          }.toList
        )
    override val placementStrategy
        : Optional[List[zio.aws.ecs.model.PlacementStrategy.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placementStrategy())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.PlacementStrategy.wrap(item)
          }.toList
        )
    override val networkConfiguration
        : Optional[zio.aws.ecs.model.NetworkConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkConfiguration())
        .map(value => zio.aws.ecs.model.NetworkConfiguration.wrap(value))
    override val healthCheckGracePeriodSeconds: Optional[BoxedInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthCheckGracePeriodSeconds())
        .map(value => value: BoxedInteger)
    override val schedulingStrategy
        : Optional[zio.aws.ecs.model.SchedulingStrategy] = zio.aws.core.internal
      .optionalFromNullable(impl.schedulingStrategy())
      .map(value => zio.aws.ecs.model.SchedulingStrategy.wrap(value))
    override val deploymentController
        : Optional[zio.aws.ecs.model.DeploymentController.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentController())
        .map(value => zio.aws.ecs.model.DeploymentController.wrap(value))
    override val tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Tag.wrap(item)
          }.toList
        )
    override val enableECSManagedTags: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enableECSManagedTags())
      .map(value => value: Boolean)
    override val propagateTags: Optional[zio.aws.ecs.model.PropagateTags] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propagateTags())
        .map(value => zio.aws.ecs.model.PropagateTags.wrap(value))
    override val enableExecuteCommand: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enableExecuteCommand())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.CreateServiceRequest
  ): zio.aws.ecs.model.CreateServiceRequest.ReadOnly = new Wrapper(impl)
}
