package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait TaskSetField {
  def unwrap: software.amazon.awssdk.services.ecs.model.TaskSetField
}
object TaskSetField {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.TaskSetField
  ): zio.aws.ecs.model.TaskSetField = value match {
    case software.amazon.awssdk.services.ecs.model.TaskSetField.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.TaskSetField.TAGS =>
      val r = TAGS
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.TaskSetField {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.TaskSetField =
      software.amazon.awssdk.services.ecs.model.TaskSetField.UNKNOWN_TO_SDK_VERSION
  }
  case object TAGS extends zio.aws.ecs.model.TaskSetField {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.TaskSetField =
      software.amazon.awssdk.services.ecs.model.TaskSetField.TAGS
  }
}
