package zio.aws.ecs.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.{Timestamp, Integer}
import scala.jdk.CollectionConverters._
final case class TaskSet(
    id: Optional[String] = Optional.Absent,
    taskSetArn: Optional[String] = Optional.Absent,
    serviceArn: Optional[String] = Optional.Absent,
    clusterArn: Optional[String] = Optional.Absent,
    startedBy: Optional[String] = Optional.Absent,
    externalId: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    taskDefinition: Optional[String] = Optional.Absent,
    computedDesiredCount: Optional[Integer] = Optional.Absent,
    pendingCount: Optional[Integer] = Optional.Absent,
    runningCount: Optional[Integer] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent,
    launchType: Optional[zio.aws.ecs.model.LaunchType] = Optional.Absent,
    capacityProviderStrategy: Optional[
      Iterable[zio.aws.ecs.model.CapacityProviderStrategyItem]
    ] = Optional.Absent,
    platformVersion: Optional[String] = Optional.Absent,
    platformFamily: Optional[String] = Optional.Absent,
    networkConfiguration: Optional[zio.aws.ecs.model.NetworkConfiguration] =
      Optional.Absent,
    loadBalancers: Optional[Iterable[zio.aws.ecs.model.LoadBalancer]] =
      Optional.Absent,
    serviceRegistries: Optional[Iterable[zio.aws.ecs.model.ServiceRegistry]] =
      Optional.Absent,
    scale: Optional[zio.aws.ecs.model.Scale] = Optional.Absent,
    stabilityStatus: Optional[zio.aws.ecs.model.StabilityStatus] =
      Optional.Absent,
    stabilityStatusAt: Optional[Timestamp] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ecs.model.Tag]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.TaskSet = {
    import TaskSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.TaskSet
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(taskSetArn.map(value => value: java.lang.String))(
        _.taskSetArn
      )
      .optionallyWith(serviceArn.map(value => value: java.lang.String))(
        _.serviceArn
      )
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(startedBy.map(value => value: java.lang.String))(
        _.startedBy
      )
      .optionallyWith(externalId.map(value => value: java.lang.String))(
        _.externalId
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(taskDefinition.map(value => value: java.lang.String))(
        _.taskDefinition
      )
      .optionallyWith(
        computedDesiredCount.map(value => value: java.lang.Integer)
      )(_.computedDesiredCount)
      .optionallyWith(pendingCount.map(value => value: java.lang.Integer))(
        _.pendingCount
      )
      .optionallyWith(runningCount.map(value => value: java.lang.Integer))(
        _.runningCount
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(launchType.map(value => value.unwrap))(_.launchType)
      .optionallyWith(
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.capacityProviderStrategy)
      .optionallyWith(platformVersion.map(value => value: java.lang.String))(
        _.platformVersion
      )
      .optionallyWith(platformFamily.map(value => value: java.lang.String))(
        _.platformFamily
      )
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .optionallyWith(
        loadBalancers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loadBalancers)
      .optionallyWith(
        serviceRegistries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceRegistries)
      .optionallyWith(scale.map(value => value.buildAwsValue()))(_.scale)
      .optionallyWith(stabilityStatus.map(value => value.unwrap))(
        _.stabilityStatus
      )
      .optionallyWith(
        stabilityStatusAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.stabilityStatusAt)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.TaskSet.ReadOnly =
    zio.aws.ecs.model.TaskSet.wrap(buildAwsValue())
}
object TaskSet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.TaskSet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.TaskSet = zio.aws.ecs.model.TaskSet(
      id.map(value => value),
      taskSetArn.map(value => value),
      serviceArn.map(value => value),
      clusterArn.map(value => value),
      startedBy.map(value => value),
      externalId.map(value => value),
      status.map(value => value),
      taskDefinition.map(value => value),
      computedDesiredCount.map(value => value),
      pendingCount.map(value => value),
      runningCount.map(value => value),
      createdAt.map(value => value),
      updatedAt.map(value => value),
      launchType.map(value => value),
      capacityProviderStrategy.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      platformVersion.map(value => value),
      platformFamily.map(value => value),
      networkConfiguration.map(value => value.asEditable),
      loadBalancers.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      serviceRegistries.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      scale.map(value => value.asEditable),
      stabilityStatus.map(value => value),
      stabilityStatusAt.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def id: Optional[String]
    def taskSetArn: Optional[String]
    def serviceArn: Optional[String]
    def clusterArn: Optional[String]
    def startedBy: Optional[String]
    def externalId: Optional[String]
    def status: Optional[String]
    def taskDefinition: Optional[String]
    def computedDesiredCount: Optional[Integer]
    def pendingCount: Optional[Integer]
    def runningCount: Optional[Integer]
    def createdAt: Optional[Timestamp]
    def updatedAt: Optional[Timestamp]
    def launchType: Optional[zio.aws.ecs.model.LaunchType]
    def capacityProviderStrategy: Optional[
      List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]
    ]
    def platformVersion: Optional[String]
    def platformFamily: Optional[String]
    def networkConfiguration
        : Optional[zio.aws.ecs.model.NetworkConfiguration.ReadOnly]
    def loadBalancers: Optional[List[zio.aws.ecs.model.LoadBalancer.ReadOnly]]
    def serviceRegistries
        : Optional[List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]]
    def scale: Optional[zio.aws.ecs.model.Scale.ReadOnly]
    def stabilityStatus: Optional[zio.aws.ecs.model.StabilityStatus]
    def stabilityStatusAt: Optional[Timestamp]
    def tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getTaskSetArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskSetArn", taskSetArn)
    def getServiceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceArn", serviceArn)
    def getClusterArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getStartedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("startedBy", startedBy)
    def getExternalId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("externalId", externalId)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getTaskDefinition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskDefinition", taskDefinition)
    def getComputedDesiredCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("computedDesiredCount", computedDesiredCount)
    def getPendingCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("pendingCount", pendingCount)
    def getRunningCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("runningCount", runningCount)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getLaunchType: ZIO[Any, AwsError, zio.aws.ecs.model.LaunchType] =
      AwsError.unwrapOptionField("launchType", launchType)
    def getCapacityProviderStrategy: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "capacityProviderStrategy",
      capacityProviderStrategy
    )
    def getPlatformVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getPlatformFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformFamily", platformFamily)
    def getNetworkConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.NetworkConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
    def getLoadBalancers
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.LoadBalancer.ReadOnly]] =
      AwsError.unwrapOptionField("loadBalancers", loadBalancers)
    def getServiceRegistries
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]] =
      AwsError.unwrapOptionField("serviceRegistries", serviceRegistries)
    def getScale: ZIO[Any, AwsError, zio.aws.ecs.model.Scale.ReadOnly] =
      AwsError.unwrapOptionField("scale", scale)
    def getStabilityStatus
        : ZIO[Any, AwsError, zio.aws.ecs.model.StabilityStatus] =
      AwsError.unwrapOptionField("stabilityStatus", stabilityStatus)
    def getStabilityStatusAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("stabilityStatusAt", stabilityStatusAt)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.TaskSet
  ) extends zio.aws.ecs.model.TaskSet.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val taskSetArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.taskSetArn())
      .map(value => value: String)
    override val serviceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceArn())
      .map(value => value: String)
    override val clusterArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterArn())
      .map(value => value: String)
    override val startedBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.startedBy())
      .map(value => value: String)
    override val externalId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.externalId())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val taskDefinition: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.taskDefinition())
      .map(value => value: String)
    override val computedDesiredCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.computedDesiredCount())
      .map(value => value: Integer)
    override val pendingCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingCount())
      .map(value => value: Integer)
    override val runningCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.runningCount())
      .map(value => value: Integer)
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val launchType: Optional[zio.aws.ecs.model.LaunchType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchType())
        .map(value => zio.aws.ecs.model.LaunchType.wrap(value))
    override val capacityProviderStrategy: Optional[
      List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityProviderStrategy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.CapacityProviderStrategyItem.wrap(item)
        }.toList
      )
    override val platformVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platformVersion())
      .map(value => value: String)
    override val platformFamily: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platformFamily())
      .map(value => value: String)
    override val networkConfiguration
        : Optional[zio.aws.ecs.model.NetworkConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkConfiguration())
        .map(value => zio.aws.ecs.model.NetworkConfiguration.wrap(value))
    override val loadBalancers
        : Optional[List[zio.aws.ecs.model.LoadBalancer.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.LoadBalancer.wrap(item)
          }.toList
        )
    override val serviceRegistries
        : Optional[List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceRegistries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.ServiceRegistry.wrap(item)
          }.toList
        )
    override val scale: Optional[zio.aws.ecs.model.Scale.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scale())
        .map(value => zio.aws.ecs.model.Scale.wrap(value))
    override val stabilityStatus: Optional[zio.aws.ecs.model.StabilityStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stabilityStatus())
        .map(value => zio.aws.ecs.model.StabilityStatus.wrap(value))
    override val stabilityStatusAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.stabilityStatusAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.TaskSet
  ): zio.aws.ecs.model.TaskSet.ReadOnly = new Wrapper(impl)
}
