package zio.aws.ecs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.BoxedInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RunTaskRequest(
    capacityProviderStrategy: Optional[
      Iterable[zio.aws.ecs.model.CapacityProviderStrategyItem]
    ] = Optional.Absent,
    cluster: Optional[String] = Optional.Absent,
    count: Optional[BoxedInteger] = Optional.Absent,
    enableECSManagedTags: Optional[Boolean] = Optional.Absent,
    enableExecuteCommand: Optional[Boolean] = Optional.Absent,
    group: Optional[String] = Optional.Absent,
    launchType: Optional[zio.aws.ecs.model.LaunchType] = Optional.Absent,
    networkConfiguration: Optional[zio.aws.ecs.model.NetworkConfiguration] =
      Optional.Absent,
    overrides: Optional[zio.aws.ecs.model.TaskOverride] = Optional.Absent,
    placementConstraints: Optional[
      Iterable[zio.aws.ecs.model.PlacementConstraint]
    ] = Optional.Absent,
    placementStrategy: Optional[Iterable[zio.aws.ecs.model.PlacementStrategy]] =
      Optional.Absent,
    platformVersion: Optional[String] = Optional.Absent,
    propagateTags: Optional[zio.aws.ecs.model.PropagateTags] = Optional.Absent,
    referenceId: Optional[String] = Optional.Absent,
    startedBy: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ecs.model.Tag]] = Optional.Absent,
    taskDefinition: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.RunTaskRequest = {
    import RunTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.RunTaskRequest
      .builder()
      .optionallyWith(
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.capacityProviderStrategy)
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .optionallyWith(count.map(value => value: Integer))(_.count)
      .optionallyWith(
        enableECSManagedTags.map(value => value: java.lang.Boolean)
      )(_.enableECSManagedTags)
      .optionallyWith(
        enableExecuteCommand.map(value => value: java.lang.Boolean)
      )(_.enableExecuteCommand)
      .optionallyWith(group.map(value => value: java.lang.String))(_.group)
      .optionallyWith(launchType.map(value => value.unwrap))(_.launchType)
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .optionallyWith(overrides.map(value => value.buildAwsValue()))(
        _.overrides
      )
      .optionallyWith(
        placementConstraints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementConstraints)
      .optionallyWith(
        placementStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementStrategy)
      .optionallyWith(platformVersion.map(value => value: java.lang.String))(
        _.platformVersion
      )
      .optionallyWith(propagateTags.map(value => value.unwrap))(_.propagateTags)
      .optionallyWith(referenceId.map(value => value: java.lang.String))(
        _.referenceId
      )
      .optionallyWith(startedBy.map(value => value: java.lang.String))(
        _.startedBy
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .taskDefinition(taskDefinition: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.RunTaskRequest.ReadOnly =
    zio.aws.ecs.model.RunTaskRequest.wrap(buildAwsValue())
}
object RunTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.RunTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.RunTaskRequest =
      zio.aws.ecs.model.RunTaskRequest(
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cluster.map(value => value),
        count.map(value => value),
        enableECSManagedTags.map(value => value),
        enableExecuteCommand.map(value => value),
        group.map(value => value),
        launchType.map(value => value),
        networkConfiguration.map(value => value.asEditable),
        overrides.map(value => value.asEditable),
        placementConstraints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        placementStrategy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        platformVersion.map(value => value),
        propagateTags.map(value => value),
        referenceId.map(value => value),
        startedBy.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        taskDefinition
      )
    def capacityProviderStrategy: Optional[
      List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]
    ]
    def cluster: Optional[String]
    def count: Optional[BoxedInteger]
    def enableECSManagedTags: Optional[Boolean]
    def enableExecuteCommand: Optional[Boolean]
    def group: Optional[String]
    def launchType: Optional[zio.aws.ecs.model.LaunchType]
    def networkConfiguration
        : Optional[zio.aws.ecs.model.NetworkConfiguration.ReadOnly]
    def overrides: Optional[zio.aws.ecs.model.TaskOverride.ReadOnly]
    def placementConstraints
        : Optional[List[zio.aws.ecs.model.PlacementConstraint.ReadOnly]]
    def placementStrategy
        : Optional[List[zio.aws.ecs.model.PlacementStrategy.ReadOnly]]
    def platformVersion: Optional[String]
    def propagateTags: Optional[zio.aws.ecs.model.PropagateTags]
    def referenceId: Optional[String]
    def startedBy: Optional[String]
    def tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]]
    def taskDefinition: String
    def getCapacityProviderStrategy: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "capacityProviderStrategy",
      capacityProviderStrategy
    )
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getCount: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("count", count)
    def getEnableECSManagedTags: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableECSManagedTags", enableECSManagedTags)
    def getEnableExecuteCommand: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableExecuteCommand", enableExecuteCommand)
    def getGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("group", group)
    def getLaunchType: ZIO[Any, AwsError, zio.aws.ecs.model.LaunchType] =
      AwsError.unwrapOptionField("launchType", launchType)
    def getNetworkConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.NetworkConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
    def getOverrides
        : ZIO[Any, AwsError, zio.aws.ecs.model.TaskOverride.ReadOnly] =
      AwsError.unwrapOptionField("overrides", overrides)
    def getPlacementConstraints: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.PlacementConstraint.ReadOnly
    ]] =
      AwsError.unwrapOptionField("placementConstraints", placementConstraints)
    def getPlacementStrategy: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.PlacementStrategy.ReadOnly
    ]] = AwsError.unwrapOptionField("placementStrategy", placementStrategy)
    def getPlatformVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getPropagateTags: ZIO[Any, AwsError, zio.aws.ecs.model.PropagateTags] =
      AwsError.unwrapOptionField("propagateTags", propagateTags)
    def getReferenceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("referenceId", referenceId)
    def getStartedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("startedBy", startedBy)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTaskDefinition: ZIO[Any, Nothing, String] =
      ZIO.succeed(taskDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.RunTaskRequest
  ) extends zio.aws.ecs.model.RunTaskRequest.ReadOnly {
    override val capacityProviderStrategy: Optional[
      List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityProviderStrategy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.CapacityProviderStrategyItem.wrap(item)
        }.toList
      )
    override val cluster: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cluster())
      .map(value => value: String)
    override val count: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => value: BoxedInteger)
    override val enableECSManagedTags: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enableECSManagedTags())
      .map(value => value: Boolean)
    override val enableExecuteCommand: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enableExecuteCommand())
      .map(value => value: Boolean)
    override val group: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.group())
      .map(value => value: String)
    override val launchType: Optional[zio.aws.ecs.model.LaunchType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchType())
        .map(value => zio.aws.ecs.model.LaunchType.wrap(value))
    override val networkConfiguration
        : Optional[zio.aws.ecs.model.NetworkConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkConfiguration())
        .map(value => zio.aws.ecs.model.NetworkConfiguration.wrap(value))
    override val overrides: Optional[zio.aws.ecs.model.TaskOverride.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.overrides())
        .map(value => zio.aws.ecs.model.TaskOverride.wrap(value))
    override val placementConstraints
        : Optional[List[zio.aws.ecs.model.PlacementConstraint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placementConstraints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.PlacementConstraint.wrap(item)
          }.toList
        )
    override val placementStrategy
        : Optional[List[zio.aws.ecs.model.PlacementStrategy.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placementStrategy())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.PlacementStrategy.wrap(item)
          }.toList
        )
    override val platformVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platformVersion())
      .map(value => value: String)
    override val propagateTags: Optional[zio.aws.ecs.model.PropagateTags] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propagateTags())
        .map(value => zio.aws.ecs.model.PropagateTags.wrap(value))
    override val referenceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.referenceId())
      .map(value => value: String)
    override val startedBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.startedBy())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Tag.wrap(item)
          }.toList
        )
    override val taskDefinition: String = impl.taskDefinition(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.RunTaskRequest
  ): zio.aws.ecs.model.RunTaskRequest.ReadOnly = new Wrapper(impl)
}
