package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RuntimePlatform(
    cpuArchitecture: Optional[zio.aws.ecs.model.CPUArchitecture] =
      Optional.Absent,
    operatingSystemFamily: Optional[zio.aws.ecs.model.OSFamily] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.RuntimePlatform = {
    import RuntimePlatform.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.RuntimePlatform
      .builder()
      .optionallyWith(cpuArchitecture.map(value => value.unwrap))(
        _.cpuArchitecture
      )
      .optionallyWith(operatingSystemFamily.map(value => value.unwrap))(
        _.operatingSystemFamily
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.RuntimePlatform.ReadOnly =
    zio.aws.ecs.model.RuntimePlatform.wrap(buildAwsValue())
}
object RuntimePlatform {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.RuntimePlatform
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.RuntimePlatform =
      zio.aws.ecs.model.RuntimePlatform(
        cpuArchitecture.map(value => value),
        operatingSystemFamily.map(value => value)
      )
    def cpuArchitecture: Optional[zio.aws.ecs.model.CPUArchitecture]
    def operatingSystemFamily: Optional[zio.aws.ecs.model.OSFamily]
    def getCpuArchitecture
        : ZIO[Any, AwsError, zio.aws.ecs.model.CPUArchitecture] =
      AwsError.unwrapOptionField("cpuArchitecture", cpuArchitecture)
    def getOperatingSystemFamily
        : ZIO[Any, AwsError, zio.aws.ecs.model.OSFamily] =
      AwsError.unwrapOptionField("operatingSystemFamily", operatingSystemFamily)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.RuntimePlatform
  ) extends zio.aws.ecs.model.RuntimePlatform.ReadOnly {
    override val cpuArchitecture: Optional[zio.aws.ecs.model.CPUArchitecture] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cpuArchitecture())
        .map(value => zio.aws.ecs.model.CPUArchitecture.wrap(value))
    override val operatingSystemFamily: Optional[zio.aws.ecs.model.OSFamily] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operatingSystemFamily())
        .map(value => zio.aws.ecs.model.OSFamily.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.RuntimePlatform
  ): zio.aws.ecs.model.RuntimePlatform.ReadOnly = new Wrapper(impl)
}
