package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait CPUArchitecture {
  def unwrap: software.amazon.awssdk.services.ecs.model.CPUArchitecture
}
object CPUArchitecture {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.CPUArchitecture
  ): zio.aws.ecs.model.CPUArchitecture = value match {
    case software.amazon.awssdk.services.ecs.model.CPUArchitecture.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.CPUArchitecture.X86_64 =>
      val r = X86_64
      r
    case software.amazon.awssdk.services.ecs.model.CPUArchitecture.ARM64 =>
      val r = ARM64
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.CPUArchitecture {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.CPUArchitecture =
      software.amazon.awssdk.services.ecs.model.CPUArchitecture.UNKNOWN_TO_SDK_VERSION
  }
  case object X86_64 extends zio.aws.ecs.model.CPUArchitecture {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.CPUArchitecture =
      software.amazon.awssdk.services.ecs.model.CPUArchitecture.X86_64
  }
  case object ARM64 extends zio.aws.ecs.model.CPUArchitecture {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.CPUArchitecture =
      software.amazon.awssdk.services.ecs.model.CPUArchitecture.ARM64
  }
}
