package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutClusterCapacityProvidersRequest(
    cluster: String,
    capacityProviders: Iterable[String],
    defaultCapacityProviderStrategy: Iterable[
      zio.aws.ecs.model.CapacityProviderStrategyItem
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.PutClusterCapacityProvidersRequest = {
    import PutClusterCapacityProvidersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.PutClusterCapacityProvidersRequest
      .builder()
      .cluster(cluster: java.lang.String)
      .capacityProviders(capacityProviders.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .defaultCapacityProviderStrategy(defaultCapacityProviderStrategy.map {
        item =>
          item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.ecs.model.PutClusterCapacityProvidersRequest.ReadOnly =
    zio.aws.ecs.model.PutClusterCapacityProvidersRequest.wrap(buildAwsValue())
}
object PutClusterCapacityProvidersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.PutClusterCapacityProvidersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.PutClusterCapacityProvidersRequest =
      zio.aws.ecs.model.PutClusterCapacityProvidersRequest(
        cluster,
        capacityProviders,
        defaultCapacityProviderStrategy.map { item =>
          item.asEditable
        }
      )
    def cluster: String
    def capacityProviders: List[String]
    def defaultCapacityProviderStrategy
        : List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]
    def getCluster: ZIO[Any, Nothing, String] = ZIO.succeed(cluster)
    def getCapacityProviders: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(capacityProviders)
    def getDefaultCapacityProviderStrategy: ZIO[Any, Nothing, List[
      zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly
    ]] = ZIO.succeed(defaultCapacityProviderStrategy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.PutClusterCapacityProvidersRequest
  ) extends zio.aws.ecs.model.PutClusterCapacityProvidersRequest.ReadOnly {
    override val cluster: String = impl.cluster(): String
    override val capacityProviders: List[String] = impl
      .capacityProviders()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val defaultCapacityProviderStrategy
        : List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly] = impl
      .defaultCapacityProviderStrategy()
      .asScala
      .map { item =>
        zio.aws.ecs.model.CapacityProviderStrategyItem.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.PutClusterCapacityProvidersRequest
  ): zio.aws.ecs.model.PutClusterCapacityProvidersRequest.ReadOnly =
    new Wrapper(impl)
}
