package zio.aws.ecs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.BoxedInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ServiceRegistry(
    registryArn: Optional[String] = Optional.Absent,
    port: Optional[BoxedInteger] = Optional.Absent,
    containerName: Optional[String] = Optional.Absent,
    containerPort: Optional[BoxedInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ServiceRegistry = {
    import ServiceRegistry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ServiceRegistry
      .builder()
      .optionallyWith(registryArn.map(value => value: java.lang.String))(
        _.registryArn
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(containerName.map(value => value: java.lang.String))(
        _.containerName
      )
      .optionallyWith(containerPort.map(value => value: Integer))(
        _.containerPort
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ServiceRegistry.ReadOnly =
    zio.aws.ecs.model.ServiceRegistry.wrap(buildAwsValue())
}
object ServiceRegistry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ServiceRegistry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ServiceRegistry =
      zio.aws.ecs.model.ServiceRegistry(
        registryArn.map(value => value),
        port.map(value => value),
        containerName.map(value => value),
        containerPort.map(value => value)
      )
    def registryArn: Optional[String]
    def port: Optional[BoxedInteger]
    def containerName: Optional[String]
    def containerPort: Optional[BoxedInteger]
    def getRegistryArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("registryArn", registryArn)
    def getPort: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("port", port)
    def getContainerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerName", containerName)
    def getContainerPort: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("containerPort", containerPort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ServiceRegistry
  ) extends zio.aws.ecs.model.ServiceRegistry.ReadOnly {
    override val registryArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.registryArn())
      .map(value => value: String)
    override val port: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: BoxedInteger)
    override val containerName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.containerName())
      .map(value => value: String)
    override val containerPort: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.containerPort())
      .map(value => value: BoxedInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ServiceRegistry
  ): zio.aws.ecs.model.ServiceRegistry.ReadOnly = new Wrapper(impl)
}
