package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.BoxedBoolean
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MountPoint(
    sourceVolume: Optional[String] = Optional.Absent,
    containerPath: Optional[String] = Optional.Absent,
    readOnly: Optional[BoxedBoolean] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.MountPoint = {
    import MountPoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.MountPoint
      .builder()
      .optionallyWith(sourceVolume.map(value => value: java.lang.String))(
        _.sourceVolume
      )
      .optionallyWith(containerPath.map(value => value: java.lang.String))(
        _.containerPath
      )
      .optionallyWith(readOnly.map(value => value: java.lang.Boolean))(
        _.readOnly
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.MountPoint.ReadOnly =
    zio.aws.ecs.model.MountPoint.wrap(buildAwsValue())
}
object MountPoint {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.MountPoint] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.MountPoint = zio.aws.ecs.model.MountPoint(
      sourceVolume.map(value => value),
      containerPath.map(value => value),
      readOnly.map(value => value)
    )
    def sourceVolume: Optional[String]
    def containerPath: Optional[String]
    def readOnly: Optional[BoxedBoolean]
    def getSourceVolume: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceVolume", sourceVolume)
    def getContainerPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerPath", containerPath)
    def getReadOnly: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("readOnly", readOnly)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.MountPoint
  ) extends zio.aws.ecs.model.MountPoint.ReadOnly {
    override val sourceVolume: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceVolume())
      .map(value => value: String)
    override val containerPath: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.containerPath())
      .map(value => value: String)
    override val readOnly: Optional[BoxedBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.readOnly())
      .map(value => value: BoxedBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.MountPoint
  ): zio.aws.ecs.model.MountPoint.ReadOnly = new Wrapper(impl)
}
