package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeploymentCircuitBreaker(enable: Boolean, rollback: Boolean) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DeploymentCircuitBreaker = {
    import DeploymentCircuitBreaker.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DeploymentCircuitBreaker
      .builder()
      .enable(enable: java.lang.Boolean)
      .rollback(rollback: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DeploymentCircuitBreaker.ReadOnly =
    zio.aws.ecs.model.DeploymentCircuitBreaker.wrap(buildAwsValue())
}
object DeploymentCircuitBreaker {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DeploymentCircuitBreaker
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DeploymentCircuitBreaker =
      zio.aws.ecs.model.DeploymentCircuitBreaker(enable, rollback)
    def enable: Boolean
    def rollback: Boolean
    def getEnable: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enable)
    def getRollback: ZIO[Any, Nothing, Boolean] = ZIO.succeed(rollback)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DeploymentCircuitBreaker
  ) extends zio.aws.ecs.model.DeploymentCircuitBreaker.ReadOnly {
    override val enable: Boolean = impl.enable(): Boolean
    override val rollback: Boolean = impl.rollback(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DeploymentCircuitBreaker
  ): zio.aws.ecs.model.DeploymentCircuitBreaker.ReadOnly = new Wrapper(impl)
}
