package zio.aws.ecs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.BoxedInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Container(
    containerArn: Optional[String] = Optional.Absent,
    taskArn: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    image: Optional[String] = Optional.Absent,
    imageDigest: Optional[String] = Optional.Absent,
    runtimeId: Optional[String] = Optional.Absent,
    lastStatus: Optional[String] = Optional.Absent,
    exitCode: Optional[BoxedInteger] = Optional.Absent,
    reason: Optional[String] = Optional.Absent,
    networkBindings: Optional[Iterable[zio.aws.ecs.model.NetworkBinding]] =
      Optional.Absent,
    networkInterfaces: Optional[Iterable[zio.aws.ecs.model.NetworkInterface]] =
      Optional.Absent,
    healthStatus: Optional[zio.aws.ecs.model.HealthStatus] = Optional.Absent,
    managedAgents: Optional[Iterable[zio.aws.ecs.model.ManagedAgent]] =
      Optional.Absent,
    cpu: Optional[String] = Optional.Absent,
    memory: Optional[String] = Optional.Absent,
    memoryReservation: Optional[String] = Optional.Absent,
    gpuIds: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.Container = {
    import Container.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.Container
      .builder()
      .optionallyWith(containerArn.map(value => value: java.lang.String))(
        _.containerArn
      )
      .optionallyWith(taskArn.map(value => value: java.lang.String))(_.taskArn)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(image.map(value => value: java.lang.String))(_.image)
      .optionallyWith(imageDigest.map(value => value: java.lang.String))(
        _.imageDigest
      )
      .optionallyWith(runtimeId.map(value => value: java.lang.String))(
        _.runtimeId
      )
      .optionallyWith(lastStatus.map(value => value: java.lang.String))(
        _.lastStatus
      )
      .optionallyWith(exitCode.map(value => value: Integer))(_.exitCode)
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .optionallyWith(
        networkBindings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkBindings)
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .optionallyWith(healthStatus.map(value => value.unwrap))(_.healthStatus)
      .optionallyWith(
        managedAgents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.managedAgents)
      .optionallyWith(cpu.map(value => value: java.lang.String))(_.cpu)
      .optionallyWith(memory.map(value => value: java.lang.String))(_.memory)
      .optionallyWith(memoryReservation.map(value => value: java.lang.String))(
        _.memoryReservation
      )
      .optionallyWith(
        gpuIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.gpuIds)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.Container.ReadOnly =
    zio.aws.ecs.model.Container.wrap(buildAwsValue())
}
object Container {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.Container] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.Container = zio.aws.ecs.model.Container(
      containerArn.map(value => value),
      taskArn.map(value => value),
      name.map(value => value),
      image.map(value => value),
      imageDigest.map(value => value),
      runtimeId.map(value => value),
      lastStatus.map(value => value),
      exitCode.map(value => value),
      reason.map(value => value),
      networkBindings.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      networkInterfaces.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      healthStatus.map(value => value),
      managedAgents.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      cpu.map(value => value),
      memory.map(value => value),
      memoryReservation.map(value => value),
      gpuIds.map(value => value)
    )
    def containerArn: Optional[String]
    def taskArn: Optional[String]
    def name: Optional[String]
    def image: Optional[String]
    def imageDigest: Optional[String]
    def runtimeId: Optional[String]
    def lastStatus: Optional[String]
    def exitCode: Optional[BoxedInteger]
    def reason: Optional[String]
    def networkBindings
        : Optional[List[zio.aws.ecs.model.NetworkBinding.ReadOnly]]
    def networkInterfaces
        : Optional[List[zio.aws.ecs.model.NetworkInterface.ReadOnly]]
    def healthStatus: Optional[zio.aws.ecs.model.HealthStatus]
    def managedAgents: Optional[List[zio.aws.ecs.model.ManagedAgent.ReadOnly]]
    def cpu: Optional[String]
    def memory: Optional[String]
    def memoryReservation: Optional[String]
    def gpuIds: Optional[List[String]]
    def getContainerArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerArn", containerArn)
    def getTaskArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskArn", taskArn)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getImage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("image", image)
    def getImageDigest: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageDigest", imageDigest)
    def getRuntimeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("runtimeId", runtimeId)
    def getLastStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastStatus", lastStatus)
    def getExitCode: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("exitCode", exitCode)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
    def getNetworkBindings
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.NetworkBinding.ReadOnly]] =
      AwsError.unwrapOptionField("networkBindings", networkBindings)
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.NetworkInterface.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
    def getHealthStatus: ZIO[Any, AwsError, zio.aws.ecs.model.HealthStatus] =
      AwsError.unwrapOptionField("healthStatus", healthStatus)
    def getManagedAgents
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.ManagedAgent.ReadOnly]] =
      AwsError.unwrapOptionField("managedAgents", managedAgents)
    def getCpu: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cpu", cpu)
    def getMemory: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("memory", memory)
    def getMemoryReservation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("memoryReservation", memoryReservation)
    def getGpuIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("gpuIds", gpuIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.Container
  ) extends zio.aws.ecs.model.Container.ReadOnly {
    override val containerArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.containerArn())
      .map(value => value: String)
    override val taskArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.taskArn())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val image: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.image())
      .map(value => value: String)
    override val imageDigest: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imageDigest())
      .map(value => value: String)
    override val runtimeId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.runtimeId())
      .map(value => value: String)
    override val lastStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastStatus())
      .map(value => value: String)
    override val exitCode: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.exitCode())
      .map(value => value: BoxedInteger)
    override val reason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => value: String)
    override val networkBindings
        : Optional[List[zio.aws.ecs.model.NetworkBinding.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkBindings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.NetworkBinding.wrap(item)
          }.toList
        )
    override val networkInterfaces
        : Optional[List[zio.aws.ecs.model.NetworkInterface.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaces())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.NetworkInterface.wrap(item)
          }.toList
        )
    override val healthStatus: Optional[zio.aws.ecs.model.HealthStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthStatus())
        .map(value => zio.aws.ecs.model.HealthStatus.wrap(value))
    override val managedAgents
        : Optional[List[zio.aws.ecs.model.ManagedAgent.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedAgents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.ManagedAgent.wrap(item)
          }.toList
        )
    override val cpu: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cpu())
      .map(value => value: String)
    override val memory: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.memory())
      .map(value => value: String)
    override val memoryReservation: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.memoryReservation())
      .map(value => value: String)
    override val gpuIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.gpuIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.Container
  ): zio.aws.ecs.model.Container.ReadOnly = new Wrapper(impl)
}
