package zio.aws.ecs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.BoxedInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ContainerStateChange(
    containerName: Optional[String] = Optional.Absent,
    imageDigest: Optional[String] = Optional.Absent,
    runtimeId: Optional[String] = Optional.Absent,
    exitCode: Optional[BoxedInteger] = Optional.Absent,
    networkBindings: Optional[Iterable[zio.aws.ecs.model.NetworkBinding]] =
      Optional.Absent,
    reason: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ContainerStateChange = {
    import ContainerStateChange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ContainerStateChange
      .builder()
      .optionallyWith(containerName.map(value => value: java.lang.String))(
        _.containerName
      )
      .optionallyWith(imageDigest.map(value => value: java.lang.String))(
        _.imageDigest
      )
      .optionallyWith(runtimeId.map(value => value: java.lang.String))(
        _.runtimeId
      )
      .optionallyWith(exitCode.map(value => value: Integer))(_.exitCode)
      .optionallyWith(
        networkBindings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkBindings)
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ContainerStateChange.ReadOnly =
    zio.aws.ecs.model.ContainerStateChange.wrap(buildAwsValue())
}
object ContainerStateChange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ContainerStateChange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ContainerStateChange =
      zio.aws.ecs.model.ContainerStateChange(
        containerName.map(value => value),
        imageDigest.map(value => value),
        runtimeId.map(value => value),
        exitCode.map(value => value),
        networkBindings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reason.map(value => value),
        status.map(value => value)
      )
    def containerName: Optional[String]
    def imageDigest: Optional[String]
    def runtimeId: Optional[String]
    def exitCode: Optional[BoxedInteger]
    def networkBindings
        : Optional[List[zio.aws.ecs.model.NetworkBinding.ReadOnly]]
    def reason: Optional[String]
    def status: Optional[String]
    def getContainerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerName", containerName)
    def getImageDigest: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageDigest", imageDigest)
    def getRuntimeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("runtimeId", runtimeId)
    def getExitCode: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("exitCode", exitCode)
    def getNetworkBindings
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.NetworkBinding.ReadOnly]] =
      AwsError.unwrapOptionField("networkBindings", networkBindings)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ContainerStateChange
  ) extends zio.aws.ecs.model.ContainerStateChange.ReadOnly {
    override val containerName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.containerName())
      .map(value => value: String)
    override val imageDigest: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imageDigest())
      .map(value => value: String)
    override val runtimeId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.runtimeId())
      .map(value => value: String)
    override val exitCode: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.exitCode())
      .map(value => value: BoxedInteger)
    override val networkBindings
        : Optional[List[zio.aws.ecs.model.NetworkBinding.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkBindings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.NetworkBinding.wrap(item)
          }.toList
        )
    override val reason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ContainerStateChange
  ): zio.aws.ecs.model.ContainerStateChange.ReadOnly = new Wrapper(impl)
}
