package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.BoxedBoolean
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VolumeFrom(
    sourceContainer: Optional[String] = Optional.Absent,
    readOnly: Optional[BoxedBoolean] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.VolumeFrom = {
    import VolumeFrom.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.VolumeFrom
      .builder()
      .optionallyWith(sourceContainer.map(value => value: java.lang.String))(
        _.sourceContainer
      )
      .optionallyWith(readOnly.map(value => value: java.lang.Boolean))(
        _.readOnly
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.VolumeFrom.ReadOnly =
    zio.aws.ecs.model.VolumeFrom.wrap(buildAwsValue())
}
object VolumeFrom {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.VolumeFrom] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.VolumeFrom = zio.aws.ecs.model.VolumeFrom(
      sourceContainer.map(value => value),
      readOnly.map(value => value)
    )
    def sourceContainer: Optional[String]
    def readOnly: Optional[BoxedBoolean]
    def getSourceContainer: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceContainer", sourceContainer)
    def getReadOnly: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("readOnly", readOnly)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.VolumeFrom
  ) extends zio.aws.ecs.model.VolumeFrom.ReadOnly {
    override val sourceContainer: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceContainer())
      .map(value => value: String)
    override val readOnly: Optional[BoxedBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.readOnly())
      .map(value => value: BoxedBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.VolumeFrom
  ): zio.aws.ecs.model.VolumeFrom.ReadOnly = new Wrapper(impl)
}
