package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateCapacityProviderResponse(
    capacityProvider: Optional[zio.aws.ecs.model.CapacityProvider] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.UpdateCapacityProviderResponse = {
    import UpdateCapacityProviderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.UpdateCapacityProviderResponse
      .builder()
      .optionallyWith(capacityProvider.map(value => value.buildAwsValue()))(
        _.capacityProvider
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.UpdateCapacityProviderResponse.ReadOnly =
    zio.aws.ecs.model.UpdateCapacityProviderResponse.wrap(buildAwsValue())
}
object UpdateCapacityProviderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.UpdateCapacityProviderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.UpdateCapacityProviderResponse =
      zio.aws.ecs.model.UpdateCapacityProviderResponse(
        capacityProvider.map(value => value.asEditable)
      )
    def capacityProvider: Optional[zio.aws.ecs.model.CapacityProvider.ReadOnly]
    def getCapacityProvider
        : ZIO[Any, AwsError, zio.aws.ecs.model.CapacityProvider.ReadOnly] =
      AwsError.unwrapOptionField("capacityProvider", capacityProvider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.UpdateCapacityProviderResponse
  ) extends zio.aws.ecs.model.UpdateCapacityProviderResponse.ReadOnly {
    override val capacityProvider
        : Optional[zio.aws.ecs.model.CapacityProvider.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityProvider())
        .map(value => zio.aws.ecs.model.CapacityProvider.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.UpdateCapacityProviderResponse
  ): zio.aws.ecs.model.UpdateCapacityProviderResponse.ReadOnly = new Wrapper(
    impl
  )
}
