package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SystemControl(
    namespace: Optional[String] = Optional.Absent,
    value: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.SystemControl = {
    import SystemControl.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.SystemControl
      .builder()
      .optionallyWith(namespace.map(value => value: java.lang.String))(
        _.namespace
      )
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.SystemControl.ReadOnly =
    zio.aws.ecs.model.SystemControl.wrap(buildAwsValue())
}
object SystemControl {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.SystemControl] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.SystemControl = zio.aws.ecs.model
      .SystemControl(namespace.map(value => value), value.map(value => value))
    def namespace: Optional[String]
    def value: Optional[String]
    def getNamespace: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.SystemControl
  ) extends zio.aws.ecs.model.SystemControl.ReadOnly {
    override val namespace: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value => value: String)
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.SystemControl
  ): zio.aws.ecs.model.SystemControl.ReadOnly = new Wrapper(impl)
}
