package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutAttributesResponse(
    attributes: Optional[Iterable[zio.aws.ecs.model.Attribute]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.PutAttributesResponse = {
    import PutAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.PutAttributesResponse
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.PutAttributesResponse.ReadOnly =
    zio.aws.ecs.model.PutAttributesResponse.wrap(buildAwsValue())
}
object PutAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.PutAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.PutAttributesResponse =
      zio.aws.ecs.model.PutAttributesResponse(
        attributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def attributes: Optional[List[zio.aws.ecs.model.Attribute.ReadOnly]]
    def getAttributes
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Attribute.ReadOnly]] =
      AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.PutAttributesResponse
  ) extends zio.aws.ecs.model.PutAttributesResponse.ReadOnly {
    override val attributes
        : Optional[List[zio.aws.ecs.model.Attribute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Attribute.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.PutAttributesResponse
  ): zio.aws.ecs.model.PutAttributesResponse.ReadOnly = new Wrapper(impl)
}
