package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InferenceAcceleratorOverride(
    deviceName: Optional[String] = Optional.Absent,
    deviceType: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.InferenceAcceleratorOverride = {
    import InferenceAcceleratorOverride.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.InferenceAcceleratorOverride
      .builder()
      .optionallyWith(deviceName.map(value => value: java.lang.String))(
        _.deviceName
      )
      .optionallyWith(deviceType.map(value => value: java.lang.String))(
        _.deviceType
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.InferenceAcceleratorOverride.ReadOnly =
    zio.aws.ecs.model.InferenceAcceleratorOverride.wrap(buildAwsValue())
}
object InferenceAcceleratorOverride {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.InferenceAcceleratorOverride
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.InferenceAcceleratorOverride =
      zio.aws.ecs.model.InferenceAcceleratorOverride(
        deviceName.map(value => value),
        deviceType.map(value => value)
      )
    def deviceName: Optional[String]
    def deviceType: Optional[String]
    def getDeviceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deviceName", deviceName)
    def getDeviceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deviceType", deviceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.InferenceAcceleratorOverride
  ) extends zio.aws.ecs.model.InferenceAcceleratorOverride.ReadOnly {
    override val deviceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceName())
      .map(value => value: String)
    override val deviceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceType())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.InferenceAcceleratorOverride
  ): zio.aws.ecs.model.InferenceAcceleratorOverride.ReadOnly = new Wrapper(impl)
}
