package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class FSxWindowsFileServerAuthorizationConfig(
    credentialsParameter: String,
    domain: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.FSxWindowsFileServerAuthorizationConfig = {
    import FSxWindowsFileServerAuthorizationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.FSxWindowsFileServerAuthorizationConfig
      .builder()
      .credentialsParameter(credentialsParameter: java.lang.String)
      .domain(domain: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ecs.model.FSxWindowsFileServerAuthorizationConfig.ReadOnly =
    zio.aws.ecs.model.FSxWindowsFileServerAuthorizationConfig
      .wrap(buildAwsValue())
}
object FSxWindowsFileServerAuthorizationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.FSxWindowsFileServerAuthorizationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.FSxWindowsFileServerAuthorizationConfig =
      zio.aws.ecs.model
        .FSxWindowsFileServerAuthorizationConfig(credentialsParameter, domain)
    def credentialsParameter: String
    def domain: String
    def getCredentialsParameter: ZIO[Any, Nothing, String] =
      ZIO.succeed(credentialsParameter)
    def getDomain: ZIO[Any, Nothing, String] = ZIO.succeed(domain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.FSxWindowsFileServerAuthorizationConfig
  ) extends zio.aws.ecs.model.FSxWindowsFileServerAuthorizationConfig.ReadOnly {
    override val credentialsParameter: String =
      impl.credentialsParameter(): String
    override val domain: String = impl.domain(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.FSxWindowsFileServerAuthorizationConfig
  ): zio.aws.ecs.model.FSxWindowsFileServerAuthorizationConfig.ReadOnly =
    new Wrapper(impl)
}
