package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: String,
    tags: Iterable[zio.aws.ecs.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.TagResourceRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.TagResourceRequest.ReadOnly =
    zio.aws.ecs.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.TagResourceRequest =
      zio.aws.ecs.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: String
    def tags: List[zio.aws.ecs.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, List[zio.aws.ecs.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.TagResourceRequest
  ) extends zio.aws.ecs.model.TagResourceRequest.ReadOnly {
    override val resourceArn: String = impl.resourceArn(): String
    override val tags: List[zio.aws.ecs.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.ecs.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.TagResourceRequest
  ): zio.aws.ecs.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
