package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FirelensConfiguration(
    `type`: zio.aws.ecs.model.FirelensConfigurationType,
    options: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.FirelensConfiguration = {
    import FirelensConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.FirelensConfiguration
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(
        options.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.options)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.FirelensConfiguration.ReadOnly =
    zio.aws.ecs.model.FirelensConfiguration.wrap(buildAwsValue())
}
object FirelensConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.FirelensConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.FirelensConfiguration = zio.aws.ecs.model
      .FirelensConfiguration(`type`, options.map(value => value))
    def `type`: zio.aws.ecs.model.FirelensConfigurationType
    def options: Optional[Map[String, String]]
    def getType
        : ZIO[Any, Nothing, zio.aws.ecs.model.FirelensConfigurationType] =
      ZIO.succeed(`type`)
    def getOptions: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("options", options)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.FirelensConfiguration
  ) extends zio.aws.ecs.model.FirelensConfiguration.ReadOnly {
    override val `type`: zio.aws.ecs.model.FirelensConfigurationType =
      zio.aws.ecs.model.FirelensConfigurationType.wrap(impl.`type`())
    override val options: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.options())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.FirelensConfiguration
  ): zio.aws.ecs.model.FirelensConfiguration.ReadOnly = new Wrapper(impl)
}
