package zio.aws.ecs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.BoxedInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DeploymentConfiguration(
    deploymentCircuitBreaker: Optional[
      zio.aws.ecs.model.DeploymentCircuitBreaker
    ] = Optional.Absent,
    maximumPercent: Optional[BoxedInteger] = Optional.Absent,
    minimumHealthyPercent: Optional[BoxedInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DeploymentConfiguration = {
    import DeploymentConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DeploymentConfiguration
      .builder()
      .optionallyWith(
        deploymentCircuitBreaker.map(value => value.buildAwsValue())
      )(_.deploymentCircuitBreaker)
      .optionallyWith(maximumPercent.map(value => value: Integer))(
        _.maximumPercent
      )
      .optionallyWith(minimumHealthyPercent.map(value => value: Integer))(
        _.minimumHealthyPercent
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DeploymentConfiguration.ReadOnly =
    zio.aws.ecs.model.DeploymentConfiguration.wrap(buildAwsValue())
}
object DeploymentConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DeploymentConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DeploymentConfiguration =
      zio.aws.ecs.model.DeploymentConfiguration(
        deploymentCircuitBreaker.map(value => value.asEditable),
        maximumPercent.map(value => value),
        minimumHealthyPercent.map(value => value)
      )
    def deploymentCircuitBreaker
        : Optional[zio.aws.ecs.model.DeploymentCircuitBreaker.ReadOnly]
    def maximumPercent: Optional[BoxedInteger]
    def minimumHealthyPercent: Optional[BoxedInteger]
    def getDeploymentCircuitBreaker: ZIO[
      Any,
      AwsError,
      zio.aws.ecs.model.DeploymentCircuitBreaker.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deploymentCircuitBreaker",
      deploymentCircuitBreaker
    )
    def getMaximumPercent: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("maximumPercent", maximumPercent)
    def getMinimumHealthyPercent: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("minimumHealthyPercent", minimumHealthyPercent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DeploymentConfiguration
  ) extends zio.aws.ecs.model.DeploymentConfiguration.ReadOnly {
    override val deploymentCircuitBreaker
        : Optional[zio.aws.ecs.model.DeploymentCircuitBreaker.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentCircuitBreaker())
        .map(value => zio.aws.ecs.model.DeploymentCircuitBreaker.wrap(value))
    override val maximumPercent: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maximumPercent())
      .map(value => value: BoxedInteger)
    override val minimumHealthyPercent: Optional[BoxedInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minimumHealthyPercent())
        .map(value => value: BoxedInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DeploymentConfiguration
  ): zio.aws.ecs.model.DeploymentConfiguration.ReadOnly = new Wrapper(impl)
}
