package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Tmpfs(
    containerPath: String,
    size: Integer,
    mountOptions: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.Tmpfs = {
    import Tmpfs.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.Tmpfs
      .builder()
      .containerPath(containerPath: java.lang.String)
      .size(size: java.lang.Integer)
      .optionallyWith(
        mountOptions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.mountOptions)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.Tmpfs.ReadOnly =
    zio.aws.ecs.model.Tmpfs.wrap(buildAwsValue())
}
object Tmpfs {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.Tmpfs] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.Tmpfs = zio.aws.ecs.model
      .Tmpfs(containerPath, size, mountOptions.map(value => value))
    def containerPath: String
    def size: Integer
    def mountOptions: Optional[List[String]]
    def getContainerPath: ZIO[Any, Nothing, String] = ZIO.succeed(containerPath)
    def getSize: ZIO[Any, Nothing, Integer] = ZIO.succeed(size)
    def getMountOptions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("mountOptions", mountOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.Tmpfs
  ) extends zio.aws.ecs.model.Tmpfs.ReadOnly {
    override val containerPath: String = impl.containerPath(): String
    override val size: Integer = impl.size(): Integer
    override val mountOptions: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.mountOptions())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.Tmpfs
  ): zio.aws.ecs.model.Tmpfs.ReadOnly = new Wrapper(impl)
}
