package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StopTaskResponse(
    task: Optional[zio.aws.ecs.model.Task] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.StopTaskResponse = {
    import StopTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.StopTaskResponse
      .builder()
      .optionallyWith(task.map(value => value.buildAwsValue()))(_.task)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.StopTaskResponse.ReadOnly =
    zio.aws.ecs.model.StopTaskResponse.wrap(buildAwsValue())
}
object StopTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.StopTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.StopTaskResponse =
      zio.aws.ecs.model.StopTaskResponse(task.map(value => value.asEditable))
    def task: Optional[zio.aws.ecs.model.Task.ReadOnly]
    def getTask: ZIO[Any, AwsError, zio.aws.ecs.model.Task.ReadOnly] =
      AwsError.unwrapOptionField("task", task)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.StopTaskResponse
  ) extends zio.aws.ecs.model.StopTaskResponse.ReadOnly {
    override val task: Optional[zio.aws.ecs.model.Task.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.task())
        .map(value => zio.aws.ecs.model.Task.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.StopTaskResponse
  ): zio.aws.ecs.model.StopTaskResponse.ReadOnly = new Wrapper(impl)
}
