package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait Scope {
  def unwrap: software.amazon.awssdk.services.ecs.model.Scope
}
object Scope {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.Scope
  ): zio.aws.ecs.model.Scope = value match {
    case software.amazon.awssdk.services.ecs.model.Scope.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.Scope.TASK =>
      val r = task
      r
    case software.amazon.awssdk.services.ecs.model.Scope.SHARED =>
      val r = shared
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.Scope {
    override def unwrap: software.amazon.awssdk.services.ecs.model.Scope =
      software.amazon.awssdk.services.ecs.model.Scope.UNKNOWN_TO_SDK_VERSION
  }
  case object task extends zio.aws.ecs.model.Scope {
    override def unwrap: software.amazon.awssdk.services.ecs.model.Scope =
      software.amazon.awssdk.services.ecs.model.Scope.TASK
  }
  case object shared extends zio.aws.ecs.model.Scope {
    override def unwrap: software.amazon.awssdk.services.ecs.model.Scope =
      software.amazon.awssdk.services.ecs.model.Scope.SHARED
  }
}
