package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Failure(
    arn: Optional[String] = Optional.Absent,
    reason: Optional[String] = Optional.Absent,
    detail: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.Failure = {
    import Failure.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.Failure
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .optionallyWith(detail.map(value => value: java.lang.String))(_.detail)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.Failure.ReadOnly =
    zio.aws.ecs.model.Failure.wrap(buildAwsValue())
}
object Failure {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.Failure] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.Failure = zio.aws.ecs.model.Failure(
      arn.map(value => value),
      reason.map(value => value),
      detail.map(value => value)
    )
    def arn: Optional[String]
    def reason: Optional[String]
    def detail: Optional[String]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
    def getDetail: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("detail", detail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.Failure
  ) extends zio.aws.ecs.model.Failure.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val reason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => value: String)
    override val detail: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.detail())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.Failure
  ): zio.aws.ecs.model.Failure.ReadOnly = new Wrapper(impl)
}
