package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeTaskDefinitionRequest(
    taskDefinition: String,
    include: Optional[Iterable[zio.aws.ecs.model.TaskDefinitionField]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DescribeTaskDefinitionRequest = {
    import DescribeTaskDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DescribeTaskDefinitionRequest
      .builder()
      .taskDefinition(taskDefinition: java.lang.String)
      .optionallyWith(
        include.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.includeWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DescribeTaskDefinitionRequest.ReadOnly =
    zio.aws.ecs.model.DescribeTaskDefinitionRequest.wrap(buildAwsValue())
}
object DescribeTaskDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DescribeTaskDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DescribeTaskDefinitionRequest =
      zio.aws.ecs.model.DescribeTaskDefinitionRequest(
        taskDefinition,
        include.map(value => value)
      )
    def taskDefinition: String
    def include: Optional[List[zio.aws.ecs.model.TaskDefinitionField]]
    def getTaskDefinition: ZIO[Any, Nothing, String] =
      ZIO.succeed(taskDefinition)
    def getInclude
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.TaskDefinitionField]] =
      AwsError.unwrapOptionField("include", include)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DescribeTaskDefinitionRequest
  ) extends zio.aws.ecs.model.DescribeTaskDefinitionRequest.ReadOnly {
    override val taskDefinition: String = impl.taskDefinition(): String
    override val include
        : Optional[List[zio.aws.ecs.model.TaskDefinitionField]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.include())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.TaskDefinitionField.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DescribeTaskDefinitionRequest
  ): zio.aws.ecs.model.DescribeTaskDefinitionRequest.ReadOnly = new Wrapper(
    impl
  )
}
