package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait AgentUpdateStatus {
  def unwrap: software.amazon.awssdk.services.ecs.model.AgentUpdateStatus
}
object AgentUpdateStatus {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.AgentUpdateStatus
  ): zio.aws.ecs.model.AgentUpdateStatus = value match {
    case software.amazon.awssdk.services.ecs.model.AgentUpdateStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.AgentUpdateStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.ecs.model.AgentUpdateStatus.STAGING =>
      val r = STAGING
      r
    case software.amazon.awssdk.services.ecs.model.AgentUpdateStatus.STAGED =>
      val r = STAGED
      r
    case software.amazon.awssdk.services.ecs.model.AgentUpdateStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.ecs.model.AgentUpdateStatus.UPDATED =>
      val r = UPDATED
      r
    case software.amazon.awssdk.services.ecs.model.AgentUpdateStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.AgentUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.AgentUpdateStatus =
      software.amazon.awssdk.services.ecs.model.AgentUpdateStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.ecs.model.AgentUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.AgentUpdateStatus =
      software.amazon.awssdk.services.ecs.model.AgentUpdateStatus.PENDING
  }
  case object STAGING extends zio.aws.ecs.model.AgentUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.AgentUpdateStatus =
      software.amazon.awssdk.services.ecs.model.AgentUpdateStatus.STAGING
  }
  case object STAGED extends zio.aws.ecs.model.AgentUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.AgentUpdateStatus =
      software.amazon.awssdk.services.ecs.model.AgentUpdateStatus.STAGED
  }
  case object UPDATING extends zio.aws.ecs.model.AgentUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.AgentUpdateStatus =
      software.amazon.awssdk.services.ecs.model.AgentUpdateStatus.UPDATING
  }
  case object UPDATED extends zio.aws.ecs.model.AgentUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.AgentUpdateStatus =
      software.amazon.awssdk.services.ecs.model.AgentUpdateStatus.UPDATED
  }
  case object FAILED extends zio.aws.ecs.model.AgentUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.AgentUpdateStatus =
      software.amazon.awssdk.services.ecs.model.AgentUpdateStatus.FAILED
  }
}
