package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait ManagedTerminationProtection {
  def unwrap
      : software.amazon.awssdk.services.ecs.model.ManagedTerminationProtection
}
object ManagedTerminationProtection {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.ManagedTerminationProtection
  ): zio.aws.ecs.model.ManagedTerminationProtection = value match {
    case software.amazon.awssdk.services.ecs.model.ManagedTerminationProtection.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.ManagedTerminationProtection.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.ecs.model.ManagedTerminationProtection.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ecs.model.ManagedTerminationProtection {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ManagedTerminationProtection =
      software.amazon.awssdk.services.ecs.model.ManagedTerminationProtection.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.ecs.model.ManagedTerminationProtection {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ManagedTerminationProtection =
      software.amazon.awssdk.services.ecs.model.ManagedTerminationProtection.ENABLED
  }
  case object DISABLED extends zio.aws.ecs.model.ManagedTerminationProtection {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ManagedTerminationProtection =
      software.amazon.awssdk.services.ecs.model.ManagedTerminationProtection.DISABLED
  }
}
