package zio.aws.ecs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.BoxedInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListServicesRequest(
    cluster: Optional[String] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[BoxedInteger] = Optional.Absent,
    launchType: Optional[zio.aws.ecs.model.LaunchType] = Optional.Absent,
    schedulingStrategy: Optional[zio.aws.ecs.model.SchedulingStrategy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ListServicesRequest = {
    import ListServicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ListServicesRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(launchType.map(value => value.unwrap))(_.launchType)
      .optionallyWith(schedulingStrategy.map(value => value.unwrap))(
        _.schedulingStrategy
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ListServicesRequest.ReadOnly =
    zio.aws.ecs.model.ListServicesRequest.wrap(buildAwsValue())
}
object ListServicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ListServicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ListServicesRequest =
      zio.aws.ecs.model.ListServicesRequest(
        cluster.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        launchType.map(value => value),
        schedulingStrategy.map(value => value)
      )
    def cluster: Optional[String]
    def nextToken: Optional[String]
    def maxResults: Optional[BoxedInteger]
    def launchType: Optional[zio.aws.ecs.model.LaunchType]
    def schedulingStrategy: Optional[zio.aws.ecs.model.SchedulingStrategy]
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getLaunchType: ZIO[Any, AwsError, zio.aws.ecs.model.LaunchType] =
      AwsError.unwrapOptionField("launchType", launchType)
    def getSchedulingStrategy
        : ZIO[Any, AwsError, zio.aws.ecs.model.SchedulingStrategy] =
      AwsError.unwrapOptionField("schedulingStrategy", schedulingStrategy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ListServicesRequest
  ) extends zio.aws.ecs.model.ListServicesRequest.ReadOnly {
    override val cluster: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cluster())
      .map(value => value: String)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: BoxedInteger)
    override val launchType: Optional[zio.aws.ecs.model.LaunchType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchType())
        .map(value => zio.aws.ecs.model.LaunchType.wrap(value))
    override val schedulingStrategy
        : Optional[zio.aws.ecs.model.SchedulingStrategy] = zio.aws.core.internal
      .optionalFromNullable(impl.schedulingStrategy())
      .map(value => zio.aws.ecs.model.SchedulingStrategy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ListServicesRequest
  ): zio.aws.ecs.model.ListServicesRequest.ReadOnly = new Wrapper(impl)
}
