package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateTaskSetRequest(
    service: String,
    cluster: String,
    externalId: Optional[String] = Optional.Absent,
    taskDefinition: String,
    networkConfiguration: Optional[zio.aws.ecs.model.NetworkConfiguration] =
      Optional.Absent,
    loadBalancers: Optional[Iterable[zio.aws.ecs.model.LoadBalancer]] =
      Optional.Absent,
    serviceRegistries: Optional[Iterable[zio.aws.ecs.model.ServiceRegistry]] =
      Optional.Absent,
    launchType: Optional[zio.aws.ecs.model.LaunchType] = Optional.Absent,
    capacityProviderStrategy: Optional[
      Iterable[zio.aws.ecs.model.CapacityProviderStrategyItem]
    ] = Optional.Absent,
    platformVersion: Optional[String] = Optional.Absent,
    scale: Optional[zio.aws.ecs.model.Scale] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ecs.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.CreateTaskSetRequest = {
    import CreateTaskSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.CreateTaskSetRequest
      .builder()
      .service(service: java.lang.String)
      .cluster(cluster: java.lang.String)
      .optionallyWith(externalId.map(value => value: java.lang.String))(
        _.externalId
      )
      .taskDefinition(taskDefinition: java.lang.String)
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .optionallyWith(
        loadBalancers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loadBalancers)
      .optionallyWith(
        serviceRegistries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceRegistries)
      .optionallyWith(launchType.map(value => value.unwrap))(_.launchType)
      .optionallyWith(
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.capacityProviderStrategy)
      .optionallyWith(platformVersion.map(value => value: java.lang.String))(
        _.platformVersion
      )
      .optionallyWith(scale.map(value => value.buildAwsValue()))(_.scale)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.CreateTaskSetRequest.ReadOnly =
    zio.aws.ecs.model.CreateTaskSetRequest.wrap(buildAwsValue())
}
object CreateTaskSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.CreateTaskSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.CreateTaskSetRequest =
      zio.aws.ecs.model.CreateTaskSetRequest(
        service,
        cluster,
        externalId.map(value => value),
        taskDefinition,
        networkConfiguration.map(value => value.asEditable),
        loadBalancers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        serviceRegistries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        launchType.map(value => value),
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        platformVersion.map(value => value),
        scale.map(value => value.asEditable),
        clientToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def service: String
    def cluster: String
    def externalId: Optional[String]
    def taskDefinition: String
    def networkConfiguration
        : Optional[zio.aws.ecs.model.NetworkConfiguration.ReadOnly]
    def loadBalancers: Optional[List[zio.aws.ecs.model.LoadBalancer.ReadOnly]]
    def serviceRegistries
        : Optional[List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]]
    def launchType: Optional[zio.aws.ecs.model.LaunchType]
    def capacityProviderStrategy: Optional[
      List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]
    ]
    def platformVersion: Optional[String]
    def scale: Optional[zio.aws.ecs.model.Scale.ReadOnly]
    def clientToken: Optional[String]
    def tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]]
    def getService: ZIO[Any, Nothing, String] = ZIO.succeed(service)
    def getCluster: ZIO[Any, Nothing, String] = ZIO.succeed(cluster)
    def getExternalId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("externalId", externalId)
    def getTaskDefinition: ZIO[Any, Nothing, String] =
      ZIO.succeed(taskDefinition)
    def getNetworkConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.NetworkConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
    def getLoadBalancers
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.LoadBalancer.ReadOnly]] =
      AwsError.unwrapOptionField("loadBalancers", loadBalancers)
    def getServiceRegistries
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]] =
      AwsError.unwrapOptionField("serviceRegistries", serviceRegistries)
    def getLaunchType: ZIO[Any, AwsError, zio.aws.ecs.model.LaunchType] =
      AwsError.unwrapOptionField("launchType", launchType)
    def getCapacityProviderStrategy: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "capacityProviderStrategy",
      capacityProviderStrategy
    )
    def getPlatformVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getScale: ZIO[Any, AwsError, zio.aws.ecs.model.Scale.ReadOnly] =
      AwsError.unwrapOptionField("scale", scale)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.CreateTaskSetRequest
  ) extends zio.aws.ecs.model.CreateTaskSetRequest.ReadOnly {
    override val service: String = impl.service(): String
    override val cluster: String = impl.cluster(): String
    override val externalId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.externalId())
      .map(value => value: String)
    override val taskDefinition: String = impl.taskDefinition(): String
    override val networkConfiguration
        : Optional[zio.aws.ecs.model.NetworkConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkConfiguration())
        .map(value => zio.aws.ecs.model.NetworkConfiguration.wrap(value))
    override val loadBalancers
        : Optional[List[zio.aws.ecs.model.LoadBalancer.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.LoadBalancer.wrap(item)
          }.toList
        )
    override val serviceRegistries
        : Optional[List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceRegistries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.ServiceRegistry.wrap(item)
          }.toList
        )
    override val launchType: Optional[zio.aws.ecs.model.LaunchType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchType())
        .map(value => zio.aws.ecs.model.LaunchType.wrap(value))
    override val capacityProviderStrategy: Optional[
      List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityProviderStrategy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.CapacityProviderStrategyItem.wrap(item)
        }.toList
      )
    override val platformVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platformVersion())
      .map(value => value: String)
    override val scale: Optional[zio.aws.ecs.model.Scale.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scale())
        .map(value => zio.aws.ecs.model.Scale.wrap(value))
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.CreateTaskSetRequest
  ): zio.aws.ecs.model.CreateTaskSetRequest.ReadOnly = new Wrapper(impl)
}
