package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait AssignPublicIp {
  def unwrap: software.amazon.awssdk.services.ecs.model.AssignPublicIp
}
object AssignPublicIp {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.AssignPublicIp
  ): zio.aws.ecs.model.AssignPublicIp = value match {
    case software.amazon.awssdk.services.ecs.model.AssignPublicIp.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.AssignPublicIp.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.ecs.model.AssignPublicIp.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.AssignPublicIp {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.AssignPublicIp =
      software.amazon.awssdk.services.ecs.model.AssignPublicIp.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.ecs.model.AssignPublicIp {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.AssignPublicIp =
      software.amazon.awssdk.services.ecs.model.AssignPublicIp.ENABLED
  }
  case object DISABLED extends zio.aws.ecs.model.AssignPublicIp {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.AssignPublicIp =
      software.amazon.awssdk.services.ecs.model.AssignPublicIp.DISABLED
  }
}
