package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait ServiceField {
  def unwrap: software.amazon.awssdk.services.ecs.model.ServiceField
}
object ServiceField {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.ServiceField
  ): zio.aws.ecs.model.ServiceField = value match {
    case software.amazon.awssdk.services.ecs.model.ServiceField.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.ServiceField.TAGS =>
      val r = TAGS
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.ServiceField {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ServiceField =
      software.amazon.awssdk.services.ecs.model.ServiceField.UNKNOWN_TO_SDK_VERSION
  }
  case object TAGS extends zio.aws.ecs.model.ServiceField {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ServiceField =
      software.amazon.awssdk.services.ecs.model.ServiceField.TAGS
  }
}
